/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.nutrient;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.nutrient.Nutrient;
import com.equestricraft.core.nutrient.NutrientConfig;
import com.equestricraft.core.nutrient.NutrientConfigAge;
import java.util.List;

public class NutrientConfigDatabase
implements RepositoryDatasource<NutrientConfig, String> {
    @Override
    public List<NutrientConfig> retrieveAll() {
        return Query.selectAllFrom("NUTRIENT").getList(this::getNutrientConfigFromResultRow);
    }

    private NutrientConfig getNutrientConfigFromResultRow(ResultRow row) {
        Nutrient identifier = row.getEnum("IDENTIFIER", Nutrient.class);
        String name = row.getString("NAME");
        String unit = row.getString("UNIT");
        double caloriesPerUnit = row.getDouble("CALORIES_PER_UNIT");
        int burnPriority = row.getInt("BURN_PRIORITY");
        List<NutrientConfigAge> ageConfigs = this.retrieveAllAgeForNutrient(identifier);
        return new NutrientConfig(identifier, name, unit, caloriesPerUnit, burnPriority, ageConfigs);
    }

    private List<NutrientConfigAge> retrieveAllAgeForNutrient(Nutrient nutrient) {
        return Query.selectAllFrom("NUTRIENT_AGE").where(QueryColumn.column("NUTRIENT_IDENTIFIER", nutrient.name())).orderBy("AGE_MONTHS ASC").getList(this::getNutrientConfigAgeFromResultRow);
    }

    private NutrientConfigAge getNutrientConfigAgeFromResultRow(ResultRow row) {
        int ageMonths = row.getInt("AGE_MONTHS");
        double targetMinimum = row.getDouble("TARGET_MINIMUM");
        double targetMaximum = row.getDouble("TARGET_MAXIMUM");
        return new NutrientConfigAge(ageMonths, targetMinimum, targetMaximum);
    }
}

