/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.operation;

import java.util.LinkedHashSet;
import java.util.Set;

public class OperationConfirmationHandler {
    private static final OperationConfirmationHandler instance = new OperationConfirmationHandler();
    private final Set<Confirmation> confirmations = new LinkedHashSet<Confirmation>();

    public static OperationConfirmationHandler getInstance() {
        return instance;
    }

    private OperationConfirmationHandler() {
    }

    public void addConfirmation(int playerId, int operationId, int horseId, int operatingPlayerId) {
        Confirmation confirmation = new Confirmation(playerId, operationId, horseId, operatingPlayerId);
        this.confirmations.add(confirmation);
    }

    public boolean hasConfirmed(int playerId, int operationId, int horseId, int operatingPlayerId) {
        Confirmation confirmation = new Confirmation(playerId, operationId, horseId, operatingPlayerId);
        return this.confirmations.contains(confirmation);
    }

    public void removeConfirmation(int playerId, int operationId, int horseId, int operatingPlayerId) {
        Confirmation confirmation = new Confirmation(playerId, operationId, horseId, operatingPlayerId);
        this.confirmations.remove(confirmation);
    }

    private record Confirmation(int playerId, int operationId, int horseId, int operatingPlayerId) {
    }
}

