/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.operation;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.operation.Operation;
import java.util.List;

public class OperationDatabase
implements RepositoryDatasource<Operation, Integer> {
    @Override
    public List<Operation> retrieveAll() {
        return Query.selectAllFrom("OPERATION").where(QueryColumn.column("PUBLISHED", true)).getList(this::getFromResultRow);
    }

    private Operation getFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        String name = row.getString("NAME");
        String identifier = row.getString("IDENTIFIER");
        String description = row.getString("DESCRIPTION");
        int additionalHorsesRequired = row.getInt("ADDITIONAL_HORSES_REQUIRED");
        String inputPromptScript = row.getString("INPUT_PROMPT_SCRIPT");
        String preConditionScript = row.getString("PRE_CONDITION_SCRIPT");
        String priceCalculationScript = row.getString("PRICE_CALCULATION_SCRIPT");
        String riskScript = row.getString("RISK_SCRIPT");
        String processingScript = row.getString("PROCESSING_SCRIPT");
        double price = row.getDouble("PRICE");
        double basePayment = row.getDouble("BASE_PAYMENT");
        int successCoolDownHours = row.getInt("SUCCESS_COOL_DOWN_HOURS");
        int failureCoolDownHours = row.getInt("FAILURE_COOL_DOWN_HOURS");
        int playerXpReward = row.getInt("PLAYER_XP_REWARD");
        int jobXpReward = row.getInt("JOB_XP_REWARD");
        boolean restrictedAccess = row.getBoolean("RESTRICTED_ACCESS");
        double professionalRiskPercentage = row.getDouble("PROFESSIONAL_RISK_PERCENTAGE");
        double degreeRiskPercentage = row.getDouble("DEGREE_RISK_PERCENTAGE");
        double unqualifiedRiskPercentage = row.getDouble("UNQUALIFIED_RISK_PERCENTAGE");
        String finishMessage = row.getString("FINISH_MESSAGE");
        boolean requireWorkStart = row.getBoolean("REQUIRE_WORK_START");
        List<Integer> jobIds = this.getOperationJobIds(id);
        List<Integer> degreeIds = this.getOperationDegreeIds(id);
        double horseStressPercentage = row.getDouble("HORSE_STRESS_PERCENTAGE");
        String model = row.getString("MODEL");
        return new Operation(id, name, identifier, description, additionalHorsesRequired, inputPromptScript, preConditionScript, priceCalculationScript, riskScript, processingScript, price, basePayment, successCoolDownHours, failureCoolDownHours, playerXpReward, jobXpReward, restrictedAccess, professionalRiskPercentage, degreeRiskPercentage, unqualifiedRiskPercentage, finishMessage, requireWorkStart, jobIds, degreeIds, horseStressPercentage, model);
    }

    private List<Integer> getOperationJobIds(int operationId) {
        return Query.selectAllFrom("OPERATION_JOB").where(QueryColumn.column("OPERATION_ID", operationId)).getList(row -> row.getInt("JOB_ID"));
    }

    private List<Integer> getOperationDegreeIds(int operationId) {
        return Query.selectAllFrom("OPERATION_DEGREE").where(QueryColumn.column("OPERATION_ID", operationId)).getList(row -> row.getInt("UNIVERSITY_DEGREE_ID"));
    }
}

