/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.operation;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.operation.Operation;
import com.equestricraft.core.operation.OperationPageService;
import com.equestricraft.core.operation.OperationSession;
import com.equestricraft.core.operation.OperationToolItemInfo;
import com.equestricraft.core.operation.OperationToolPage;
import com.equestricraft.core.player.ECPlayer;
import java.util.Comparator;
import java.util.List;

public class OperationPageServiceImpl
extends Pagination<OperationToolItemInfo, OperationToolPage, Object, Object>
implements OperationPageService {
    @Service
    private OperationSession operationSession;
    private static final int MAXIMUM_PER_PAGE = 2;

    @Override
    public OperationToolPage retrieveOperationToolPage(ECPlayer player, int pageNumber) {
        List<Operation> operations = this.operationSession.getOperationsPlayerCanAccess(player);
        List<OperationToolItemInfo> items = operations.stream().map(this::buildInfoItem).toList();
        return (OperationToolPage)this.paginate(items, pageNumber, SortDirection.ASCENDING, null, null);
    }

    private OperationToolItemInfo buildInfoItem(Operation operation) {
        return new OperationToolItemInfo(operation.getId(), operation.getName(), operation.getDescription(), operation.getAdditionalHorsesRequired() + 1, EconomyUtilities.formatCurrency(operation.getPrice()), EconomyUtilities.formatCurrency(operation.getBasePayment()), !operation.getPriceCalculationScript().isBlank());
    }

    @Override
    protected int getMaximumPerPage() {
        return 2;
    }

    @Override
    protected boolean filter(OperationToolItemInfo item, Object filterObject) {
        return true;
    }

    @Override
    protected Comparator<OperationToolItemInfo> compare(Object sortOrderObject) {
        return Comparator.comparing(o -> o.name().toLowerCase());
    }

    @Override
    protected OperationToolPage buildPage(List<OperationToolItemInfo> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, Object filterObject) {
        return new OperationToolPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

