/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.operation;

import com.equestricraft.api.common.APIOperationDto;
import com.equestricraft.base.database.DatabaseTransactionHelper;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.common.util.ProbabilityUtils;
import com.equestricraft.core.config.APIConfigDtoImpl;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.global.APIGlobalDtoImpl;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.death.HorseDeadException;
import com.equestricraft.core.horse.illness.IllnessHorseEngine;
import com.equestricraft.core.illness.Illness;
import com.equestricraft.core.illness.IllnessRepository;
import com.equestricraft.core.operation.Operation;
import com.equestricraft.core.operation.OperationAccessInformation;
import com.equestricraft.core.operation.OperationConfirmationHandler;
import com.equestricraft.core.operation.OperationMessage;
import com.equestricraft.core.operation.OperationPerformException;
import com.equestricraft.core.operation.OperationPerformSession;
import com.equestricraft.core.operation.OperationPlayer;
import com.equestricraft.core.operation.OperationResponse;
import com.equestricraft.core.operation.OperationResponseFunction;
import com.equestricraft.core.operation.OperationRisk;
import com.equestricraft.core.operation.OperationRiskFunction;
import com.equestricraft.core.operation.OperationSession;
import com.equestricraft.core.operation.OperationTransformer;
import com.equestricraft.core.operation.OwnerConfirmationNeededException;
import com.equestricraft.core.operation.PerformOperationResponse;
import com.equestricraft.core.operation.log.OperationLastPerformedInfo;
import com.equestricraft.core.operation.log.OperationLogSession;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.job.PlayerJobSession;
import com.equestricraft.core.player.job.PlayerJobXpService;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.GroovyPromptNeededException;
import com.equestricraft.groovy.GroovySessionData;
import com.equestricraft.groovy.executor.GroovyPromptScriptExecutor;
import com.equestricraft.groovy.executor.GroovyRuleScriptExecutor;
import com.equestricraft.groovy.executor.GroovyScriptExecutor;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.groovy.executor.RuleScriptResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class OperationPerformSessionImpl
implements OperationPerformSession {
    @Service
    private OperationLogSession operationLogSession;
    @Service
    private PlayerJobXpService playerJobXpService;
    @Service
    private IllnessHorseEngine illnessHorseEngine;
    @Service
    private OperationSession operationSession;
    @Service
    private PlayerJobSession playerJobSession;
    @Service
    private OperationTransformer operationTransformer;
    @Service
    private IllnessRepository illnessRepository;
    private final OperationConfirmationHandler operationConfirmationHandler = OperationConfirmationHandler.getInstance();

    @Override
    public PerformOperationResponse performHorseInteract(OperationPlayer player, Operation operation, EQHorse horse) throws OperationPerformException, GroovyPromptNeededException, OwnerConfirmationNeededException {
        int horsesNeeded;
        if (player.isActiveOperation()) {
            if (!player.getOperation().equals(operation)) {
                throw new IllegalArgumentException("Already performing a different operation");
            }
            if (this.countRemainingAdditionalHorsesNeeded(player, operation) > 0) {
                if (horse.equals(player.getSelectedOperationHorse()) || player.getAdditionalHorses().contains(horse)) {
                    return PerformOperationResponse.horseAlreadySelected(operation);
                }
                player.addAdditionalHorse(horse);
            }
        } else {
            OperationAccessInformation access = this.operationSession.getPlayersAccessInformation(player, operation);
            this.ensurePlayerCanUse(access);
            this.ensureOwnerConfirmed(horse.getOwnerId(), horse.getId(), operation, player.getId());
            this.checkCoolDown(horse, operation);
            player.setOperation(operation);
            player.setOperationAccessInformation(access);
            player.setSelectedOperationHorse(horse);
        }
        if ((horsesNeeded = this.countRemainingAdditionalHorsesNeeded(player, operation)) <= 0) {
            PerformResponse executionResponse = this.performOperation(player);
            return executionResponse.success() ? PerformOperationResponse.success(operation, executionResponse.playerMessages(), executionResponse.ownerMessages()) : PerformOperationResponse.fail(operation, executionResponse.playerMessages(), executionResponse.ownerMessages());
        }
        return PerformOperationResponse.selectMoreHorses(operation, horsesNeeded);
    }

    private void ensurePlayerCanUse(OperationAccessInformation operationAccessInformation) throws OperationPerformException {
        if (!operationAccessInformation.useAllowed()) {
            throw new OperationPerformException(I18n.getLabel("operation.no-access"));
        }
    }

    private int countRemainingAdditionalHorsesNeeded(OperationPlayer operationPlayer, Operation operation) {
        return operation.getAdditionalHorsesRequired() - operationPlayer.getAdditionalHorseCount();
    }

    private void ensureOwnerConfirmed(int ownerId, int horseId, Operation operation, int playerPerformingId) throws OwnerConfirmationNeededException {
        if (playerPerformingId != ownerId && !this.operationConfirmationHandler.hasConfirmed(ownerId, operation.getId(), horseId, playerPerformingId)) {
            throw new OwnerConfirmationNeededException();
        }
        this.operationConfirmationHandler.removeConfirmation(ownerId, operation.getId(), horseId, playerPerformingId);
    }

    private void checkCoolDown(EQHorse horse, Operation operation) throws OperationPerformException {
        Optional<OperationLastPerformedInfo> lastPerformedInfo;
        if (operation.getSuccessCoolDownHours() > 0 && (lastPerformedInfo = this.operationLogSession.getInformationAboutLastTimeOperationPerformed(operation.getId(), horse.getId())).isPresent()) {
            this.checkCoolDown(operation, lastPerformedInfo.get());
        }
    }

    private void checkCoolDown(Operation operation, OperationLastPerformedInfo operationLastPerformedInfo) throws OperationPerformException {
        long hoursSinceLastPerformed;
        int coolDownHours = operationLastPerformedInfo.success() ? operation.getSuccessCoolDownHours() : operation.getFailureCoolDownHours();
        long hoursUntilCanPerform = (long)coolDownHours - (hoursSinceLastPerformed = operationLastPerformedInfo.durationSince().toHours());
        if (hoursUntilCanPerform > 0L) {
            throw new OperationPerformException(I18n.getLabel("operation.cool-down", hoursUntilCanPerform));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PerformResponse performOperation(OperationPlayer player) throws OperationPerformException, GroovyPromptNeededException {
        Operation operation = player.getOperation();
        EQHorse selectedHorse = player.getSelectedOperationHorse();
        this.executeInputPromptScript(player);
        this.executePreConditionScript(player);
        ECPlayer ownerOfSelectedHorse = selectedHorse.getOwner();
        boolean operatingOnOtherPlayersHorse = player.getId() != selectedHorse.getOwnerId();
        double price = 0.0;
        if (!operation.isRequireWorkStart()) {
            price = this.executePriceCalculationScript(player).orElse(operation.getPrice());
        }
        if (operatingOnOtherPlayersHorse && price > 0.0) {
            this.ensureOwnerHasEnoughMoney(price, ownerOfSelectedHorse);
        }
        OperationRisk riskCalculationResult = this.executeRiskScript(player);
        double adjustmentPercentage = this.determineAdjustmentPercentage(operation, player.getOperationAccessInformation());
        double successProbability = PercentageUtils.increaseByPercentage(riskCalculationResult.getSuccessPercentage().doubleValue(), adjustmentPercentage);
        boolean success = ProbabilityUtils.testPercentageProbability(successProbability);
        DatabaseTransactionHelper.startDatabaseTransaction();
        try {
            List<String> ownerMessages;
            List<String> playerMessages;
            if (success) {
                OperationResponse response = this.executeProcessingScript(player);
                playerMessages = response.getOperationMessages().stream().filter(OperationMessage::isShowToPlayer).map(OperationMessage::getMessage).collect(Collectors.toList());
                ownerMessages = response.getOperationMessages().stream().filter(OperationMessage::isShowToOwner).map(OperationMessage::getMessage).toList();
                if (!response.isSuccess()) throw new OperationPerformException(playerMessages.isEmpty() ? I18n.getLabel("operation.unsuccessful") : playerMessages.get(0));
                if (operatingOnOtherPlayersHorse) {
                    this.transferMoney(operation, price, player, ownerOfSelectedHorse);
                    this.giveXp(player, operation);
                }
                if (!operation.getFinishMessage().isBlank()) {
                    playerMessages.add(operation.getFinishMessage());
                }
                playerMessages = Collections.unmodifiableList(playerMessages);
            } else {
                playerMessages = Collections.singletonList(riskCalculationResult.getFailMessage() != null ? riskCalculationResult.getFailMessage() : I18n.getLabel("operation.unsuccessful"));
                ownerMessages = Collections.emptyList();
            }
            this.operationLogSession.logOperation(operation.getId(), selectedHorse.getId(), player, success);
            this.applyRisks(player, riskCalculationResult);
            player.reset();
            DatabaseTransactionHelper.commitDatabaseTransaction();
            return new PerformResponse(success, playerMessages, ownerMessages);
        }
        catch (OperationPerformException ex) {
            DatabaseTransactionHelper.rollbackDatabaseTransaction();
            throw ex;
        }
        catch (Exception ex) {
            DatabaseTransactionHelper.rollbackDatabaseTransaction();
            throw new OperationPerformException(ex);
        }
    }

    private void executeInputPromptScript(OperationPlayer player) throws OperationPerformException, GroovyPromptNeededException {
        if (player.getOperation().getInputPromptScript().isBlank()) {
            return;
        }
        try {
            GroovyPromptScriptExecutor executor = GroovyPromptScriptExecutor.start(player.getOperation().getInputPromptScript());
            this.attachScriptExecutionData(executor, player);
            GroovyScriptResponse<Void> response = executor.execute();
            this.syncNewlyDefinedVariables(response, player);
        }
        catch (GroovyException ex) {
            throw new OperationPerformException(ex);
        }
    }

    private void executePreConditionScript(OperationPlayer player) throws OperationPerformException {
        if (player.getOperation().getPreConditionScript().isBlank()) {
            return;
        }
        try {
            GroovyRuleScriptExecutor executor = GroovyRuleScriptExecutor.start(player.getOperation().getPreConditionScript());
            this.attachScriptExecutionData(executor, player);
            GroovyScriptResponse<RuleScriptResponse> response = executor.execute();
            this.syncNewlyDefinedVariables(response, player);
            RuleScriptResponse result = response.result();
            if (Boolean.FALSE.equals(result.success())) {
                throw new OperationPerformException(result.promptRequest().getMessage(), result.promptRequest().getTitle());
            }
        }
        catch (GroovyException ex) {
            throw new OperationPerformException(ex);
        }
    }

    private Optional<Double> executePriceCalculationScript(OperationPlayer player) throws OperationPerformException {
        if (player.getOperation().getPriceCalculationScript().isBlank()) {
            return Optional.empty();
        }
        try {
            GroovyStandardScriptExecutor executor = GroovyStandardScriptExecutor.start(player.getOperation().getPriceCalculationScript());
            this.attachScriptExecutionData(executor, player);
            GroovyScriptResponse response = executor.execute();
            this.syncNewlyDefinedVariables(response, player);
            Number price = (Number)response.result();
            if (price != null) {
                return Optional.of(price.doubleValue());
            }
            return Optional.empty();
        }
        catch (GroovyException ex) {
            throw new OperationPerformException(ex);
        }
    }

    private void ensureOwnerHasEnoughMoney(double price, ECPlayer ownerOfSelectedHorse) throws OperationPerformException {
        if (!ownerOfSelectedHorse.getEconomy().hasBalance(price)) {
            throw new OperationPerformException(I18n.getLabel("operation.not-enough-money"));
        }
    }

    private OperationRisk executeRiskScript(OperationPlayer player) throws OperationPerformException {
        String script = player.getOperation().getRiskScript();
        if (script.isBlank()) {
            return OperationRisk.defaultBlank();
        }
        try {
            OperationRiskFunction configurationFunction = new OperationRiskFunction();
            GroovyStandardScriptExecutor executor = (GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(script).withVariable("risk", configurationFunction);
            this.attachScriptExecutionData(executor, player);
            GroovyScriptResponse response = executor.execute();
            this.syncNewlyDefinedVariables(response, player);
            return configurationFunction.getOperationRisk();
        }
        catch (GroovyException ex) {
            throw new OperationPerformException(ex);
        }
    }

    private OperationResponse executeProcessingScript(OperationPlayer player) throws OperationPerformException {
        List<APIHorseDtoImpl> additionalHorses = player.getAdditionalHorses().stream().map(APIHorseDtoImpl::new).toList();
        try {
            OperationResponseFunction responseFunction = new OperationResponseFunction();
            GroovyStandardScriptExecutor executor = (GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(player.getOperation().getProcessingScript()).withVariable("additionalHorses", additionalHorses)).withVariable("response", responseFunction);
            this.attachScriptExecutionData(executor, player);
            GroovyScriptResponse response = executor.execute();
            this.syncNewlyDefinedVariables(response, player);
            return responseFunction.getOperationResponse();
        }
        catch (GroovyException ex) {
            throw new OperationPerformException(ex);
        }
    }

    private void attachScriptExecutionData(GroovyScriptExecutor<?> executor, OperationPlayer player) {
        APIHorseDtoImpl horse = new APIHorseDtoImpl(player.getSelectedOperationHorse());
        APIPlayerDtoImpl playerDto = new APIPlayerDtoImpl(player.getCorePlayer());
        APIOperationDto operation = this.operationTransformer.toDto(player.getOperation());
        executor.withHorse(horse);
        executor.withPlayer(playerDto);
        executor.withGlobal(new APIGlobalDtoImpl());
        executor.withConfig(new APIConfigDtoImpl());
        executor.withVariable("operation", operation);
        executor.withSessionData(player.getGroovyScriptSessionData());
        for (Map.Entry<String, Object> data : player.getGroovyScriptSessionData().data().entrySet()) {
            executor.withRootVariable(data.getKey(), data.getValue());
        }
    }

    public <T> void syncNewlyDefinedVariables(GroovyScriptResponse<T> response, OperationPlayer player) {
        GroovySessionData variableData = player.getGroovyScriptSessionData().data();
        variableData.putAll((Map<? extends String, ?>)response.extraDefinedVariables());
    }

    private void transferMoney(Operation operation, double priceToCharge, ECPlayer playerPerformingOperation, ECPlayer ownerOfSelectedHorse) {
        try {
            if (priceToCharge > 0.0) {
                ownerOfSelectedHorse.getEconomy().withdraw(priceToCharge, operation.getName(), "Operation");
            }
            if (operation.getBasePayment() > 0.0) {
                int percentageBoost = this.playerJobSession.getPlayersMoneyBoostPercentageForCurrentJob(playerPerformingOperation);
                double payment = PercentageUtils.increaseByPercentage(operation.getBasePayment(), percentageBoost);
                playerPerformingOperation.getEconomy().deposit(payment, operation.getName(), "Operation");
            }
        }
        catch (EconomyException ex) {
            throw new IllegalArgumentException("This shouldn't have happened");
        }
    }

    private void giveXp(OperationPlayer player, Operation operation) {
        if (player.getOperationAccessInformation().inJob()) {
            if (operation.getPlayerXpReward() > 0) {
                int percentageBoost = this.playerJobSession.getPlayersXpBoostPercentageForCurrentJob(player);
                int xpReward = PercentageUtils.increaseByPercentage(operation.getPlayerXpReward(), percentageBoost);
                player.getProgression().giveXp(xpReward);
            }
            if (operation.getJobXpReward() > 0) {
                this.playerJobXpService.givePlayerJobXp(player, operation.getJobXpReward());
            }
        }
    }

    private void applyRisks(OperationPlayer player, OperationRisk operationRisk) {
        Operation operation = player.getOperation();
        EQHorse horse = player.getSelectedOperationHorse();
        double adjustmentPercentage = this.determineAdjustmentPercentage(operation, player.getOperationAccessInformation());
        double deathChance = PercentageUtils.increaseByPercentage(operationRisk.getDeathPercentage().doubleValue(), adjustmentPercentage);
        if (ProbabilityUtils.testPercentageProbability(deathChance)) {
            try {
                horse.getDeath().kill(I18n.getLabel("operation.cause-of-death", operation.getName()));
            }
            catch (HorseDeadException horseDeadException) {}
        } else {
            List<Integer> illnessIdsToGive = operationRisk.getIllnessRisks().stream().filter(illness -> {
                double illnessProbability = PercentageUtils.increaseByPercentage(illness.getValue().doubleValue(), adjustmentPercentage);
                return ProbabilityUtils.testPercentageProbability(illnessProbability);
            }).map(ir -> new IllnessRiskResolve(ir.getIllnessId(), ir.getIllnessIdentifier())).map(IllnessRiskResolve::resolveId).toList();
            this.illnessHorseEngine.giveIllnessesToHorse(horse, illnessIdsToGive);
        }
    }

    private double determineAdjustmentPercentage(Operation operation, OperationAccessInformation operationAccessInformation) {
        if (operationAccessInformation.inJob()) {
            return operation.getProfessionalRiskPercentage();
        }
        if (operationAccessInformation.inDegree()) {
            return operation.getDegreeRiskPercentage();
        }
        return operation.getUnqualifiedRiskPercentage();
    }

    @Override
    public void cancelOperation(ECPlayer player) {
        OperationPlayer data = player.require(OperationPlayer.class);
        if (data.isActiveOperation()) {
            data.reset();
        }
    }

    private record PerformResponse(boolean success, List<String> playerMessages, List<String> ownerMessages) {
    }

    private class IllnessRiskResolve {
        private final int illnessId;
        private final String illnessIdentifier;

        public IllnessRiskResolve(int illnessId, String illnessIdentifier) {
            this.illnessId = illnessId;
            this.illnessIdentifier = illnessIdentifier;
        }

        public int resolveId() {
            if (this.illnessId != 0) {
                return this.illnessId;
            }
            Optional<Illness> illness = OperationPerformSessionImpl.this.illnessRepository.findByIdentifier(this.illnessIdentifier);
            return illness.orElseThrow().getId();
        }
    }
}

