/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.operation;

import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.operation.Operation;
import com.equestricraft.core.operation.OperationAccessInformation;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.groovy.GroovyScriptSessionData;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class OperationPlayer
implements ECPlayer {
    private final CorePlayer corePlayer;
    private Operation operation = null;
    private OperationAccessInformation operationAccessInformation = null;
    private EQHorse selectedOperationHorse = null;
    private final Set<EQHorse> additionalHorses = new HashSet<EQHorse>();
    private GroovyScriptSessionData groovyScriptSessionData = GroovyScriptSessionData.createNewSession();

    public OperationPlayer(CorePlayer corePlayer) {
        this.corePlayer = corePlayer;
    }

    @Override
    public CorePlayer getCorePlayer() {
        return this.corePlayer;
    }

    public boolean isActiveOperation() {
        return this.operation != null;
    }

    public void reset() {
        this.operation = null;
        this.operationAccessInformation = null;
        this.selectedOperationHorse = null;
        this.additionalHorses.clear();
        this.groovyScriptSessionData = GroovyScriptSessionData.createNewSession();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public OperationAccessInformation getOperationAccessInformation() {
        return this.operationAccessInformation;
    }

    public void setOperationAccessInformation(OperationAccessInformation operationAccessInformation) {
        this.operationAccessInformation = operationAccessInformation;
    }

    public EQHorse getSelectedOperationHorse() {
        return this.selectedOperationHorse;
    }

    public void setSelectedOperationHorse(EQHorse selectedHorse) {
        this.selectedOperationHorse = selectedHorse;
    }

    public boolean hasSelectedHorse() {
        return this.getSelectedOperationHorse() != null;
    }

    public void addAdditionalHorse(EQHorse horse) {
        this.additionalHorses.add(horse);
    }

    public Set<EQHorse> getAdditionalHorses() {
        return this.additionalHorses;
    }

    public int getAdditionalHorseCount() {
        return this.additionalHorses.size();
    }

    public GroovyScriptSessionData getGroovyScriptSessionData() {
        return this.groovyScriptSessionData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ECPlayer)) {
            return false;
        }
        ECPlayer that = (ECPlayer)o;
        return Objects.equals(this.corePlayer, that.getCorePlayer());
    }

    public int hashCode() {
        return Objects.hash(this.corePlayer);
    }
}

