/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.operation;

import com.equestricraft.api.common.configuration.operation.APIOperationMessageConfiguration;
import com.equestricraft.api.common.configuration.operation.APIOperationResponseConfiguration;
import com.equestricraft.core.operation.OperationMessage;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;

public class OperationResponse
implements APIOperationResponseConfiguration {
    private boolean success = true;
    private final List<OperationMessage> operationMessages = new ArrayList<OperationMessage>(0);

    @Override
    public void success(boolean success) {
        this.success = success;
    }

    @Override
    public void failure() {
        this.success(false);
    }

    @Override
    public void message(String message) {
        this.operationMessages.add(new OperationMessage(message, true, false));
    }

    @Override
    public void message(String message, Closure<?> closure) {
        OperationMessageConfiguration config = new OperationMessageConfiguration();
        closure.setDelegate(config);
        closure.call();
        OperationMessage operationMessage = new OperationMessage(message, config.showToPlayer, config.showToOwner);
        this.operationMessages.add(operationMessage);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<OperationMessage> getOperationMessages() {
        return this.operationMessages;
    }

    private static class OperationMessageConfiguration
    implements APIOperationMessageConfiguration {
        private boolean showToPlayer = false;
        private boolean showToOwner = false;

        private OperationMessageConfiguration() {
        }

        @Override
        public void showToPlayer(boolean show) {
            this.showToPlayer = show;
        }

        @Override
        public void showToPlayer(Closure<Boolean> closure) {
            this.showToPlayer(closure.call());
        }

        @Override
        public void showToPlayer() {
            this.showToPlayer(true);
        }

        @Override
        public void showToOwner(boolean show) {
            this.showToOwner = show;
        }

        @Override
        public void showToOwner(Closure<Boolean> closure) {
            this.showToOwner(closure.call());
        }

        @Override
        public void showToOwner() {
            this.showToOwner(true);
        }
    }
}

