/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.operation;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.operation.Operation;
import com.equestricraft.core.operation.OperationAccessInformation;
import com.equestricraft.core.operation.OperationRepository;
import com.equestricraft.core.operation.OperationSession;
import com.equestricraft.core.player.ECPlayer;
import java.util.List;
import java.util.Objects;

public class OperationSessionImpl
implements OperationSession {
    @Service
    private OperationRepository operationRepository;

    @Override
    public List<Operation> getOperationsPlayerCanAccess(ECPlayer player) {
        return this.operationRepository.streamAll().filter(o -> this.getPlayersAccessInformation(player, (Operation)o).useAllowed()).toList();
    }

    @Override
    public OperationAccessInformation getPlayersAccessInformation(ECPlayer player, Operation operation) {
        boolean playerCanUse = !operation.isRestrictedAccess() || player.getPermission().hasPermission("equestricraft.operation.tool.use-any");
        boolean playerInCorrectJob = operation.getJobIds().stream().anyMatch(j -> Objects.equals(player.getCorePlayer().getJobId(), j));
        boolean playerHasCorrectDegree = operation.getDegreeIds().stream().anyMatch(d -> player.getUniversity().hasBeenAwardedDegree((int)d, null));
        return new OperationAccessInformation(playerCanUse, playerInCorrectJob, playerHasCorrectDegree);
    }
}

