/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.operation;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.operation.Operation;
import java.util.Collections;
import java.util.List;

public record PerformOperationResponse(Operation operation, ResponseType responseType, List<String> playerMessages, List<String> ownerMessages) {
    public static PerformOperationResponse success(Operation operation, List<String> playerMessages, List<String> ownerMessages) {
        return new PerformOperationResponse(operation, ResponseType.SUCCESS, playerMessages, ownerMessages);
    }

    public static PerformOperationResponse success(Operation operation) {
        return PerformOperationResponse.success(operation, Collections.emptyList(), Collections.emptyList());
    }

    public static PerformOperationResponse horseAlreadySelected(Operation operation) {
        List<String> playerMessage = Collections.singletonList(I18n.getLabel("operation.horse-already-selected"));
        return new PerformOperationResponse(operation, ResponseType.HORSE_ALREADY_SELECTED, playerMessage, Collections.emptyList());
    }

    public static PerformOperationResponse selectMoreHorses(Operation operation, int horsesNeeded) {
        List<String> playerMessage = Collections.singletonList(I18n.getLabel("operation.select-more", horsesNeeded));
        return new PerformOperationResponse(operation, ResponseType.SELECT_MORE_HORSES, playerMessage, Collections.emptyList());
    }

    public static PerformOperationResponse fail(Operation operation, List<String> playerMessages, List<String> ownerMessages) {
        return new PerformOperationResponse(operation, ResponseType.FAILED, playerMessages, ownerMessages);
    }

    public static PerformOperationResponse fail(Operation operation) {
        return PerformOperationResponse.fail(operation, Collections.emptyList(), Collections.emptyList());
    }

    public static enum ResponseType {
        SUCCESS,
        SELECT_MORE_HORSES,
        HORSE_ALREADY_SELECTED,
        FAILED;

    }
}

