/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.operation.log;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.operation.log.OperationLog;
import java.util.List;

public class OperationLogDatabase
implements RepositoryDatasource<OperationLog, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_OPERATION_ID = "OPERATION_ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_SUCCESS = "SUCCESS";

    @Override
    public void create(OperationLog operationLog) {
        Query.insertInto("OPERATION_LOG").columns(QueryColumn.column(COLUMN_OPERATION_ID, operationLog.getOperationId()), QueryColumn.column(COLUMN_HORSE_ID, operationLog.getHorseId()), QueryColumn.column(COLUMN_PLAYER_ID, operationLog.getPlayerId()), QueryColumn.column(COLUMN_TIME_STAMP, operationLog.getTimeStamp()), QueryColumn.column(COLUMN_SUCCESS, operationLog.isSuccess())).executeGetGeneratedKey(operationLog::setId);
    }

    @Override
    public List<OperationLog> retrieveAll() {
        return Query.selectAllFrom("OPERATION_LOG").getList(this::getFromResultRow);
    }

    private OperationLog getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int operationId = row.getInt(COLUMN_OPERATION_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        boolean success = row.getBoolean(COLUMN_SUCCESS);
        return new OperationLog(id, operationId, horseId, playerId, timeStamp, success);
    }
}

