/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.operation.log;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.operation.log.OperationLog;
import com.equestricraft.core.operation.log.OperationLogDatabase;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class OperationLogRepository
extends Repository<OperationLog, Integer> {
    @Service
    private OperationLogDatabase operationLogDatabase;

    @Override
    protected RepositoryDatasource<OperationLog, Integer> getDatasource() {
        return this.operationLogDatabase;
    }

    public Optional<OperationLog> findMostRecentLogForOperationAndHorse(int operationId, int horseId) {
        return this.createSearchQuery().filter(l -> l.getOperationId() == operationId).filter(l -> l.getHorseId() == horseId).sortReverse(Comparator.comparing(OperationLog::getTimeStamp)).single();
    }

    public List<OperationLog> findLogsByHorseSince(int horseId, Date since) {
        return this.findListByPredicates(l -> l.getHorseId() == horseId, l -> l.getTimeStamp() >= since.getTime());
    }

    public Integer getCountOfOperationSince(int horseId, int operationId, Date since) {
        RepositorySearchQuery<OperationLog> query = this.createSearchQuery();
        query.filter(l -> l.getHorseId() == horseId);
        query.filter(l -> l.getOperationId() == operationId);
        query.filter(l -> l.getTimeStamp() >= since.getTime());
        return Math.toIntExact(query.count());
    }
}

