/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.operation.log;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.operation.Operation;
import com.equestricraft.core.operation.OperationRepository;
import com.equestricraft.core.operation.log.OperationLastPerformedInfo;
import com.equestricraft.core.operation.log.OperationLog;
import com.equestricraft.core.operation.log.OperationLogRepository;
import com.equestricraft.core.operation.log.OperationLogSession;
import com.equestricraft.core.player.ECPlayer;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class OperationLogSessionImpl
implements OperationLogSession {
    @Service
    private OperationLogRepository operationLogRepository;
    @Service
    private OperationRepository operationRepository;

    @Override
    public void logOperation(int operationId, int horseId, ECPlayer player, boolean success) {
        OperationLog newEntry = new OperationLog(0, operationId, horseId, player.getId(), System.currentTimeMillis(), success);
        this.operationLogRepository.add(newEntry);
    }

    @Override
    public Optional<OperationLastPerformedInfo> getInformationAboutLastTimeOperationPerformed(int operationId, int horseId) {
        Optional<OperationLog> logOptional = this.operationLogRepository.findMostRecentLogForOperationAndHorse(operationId, horseId);
        return logOptional.map(log -> new OperationLastPerformedInfo(log.isSuccess(), DateUtils.durationSince(log.getTimeStamp())));
    }

    @Override
    public List<Operation> getOperationsPerformedSince(int horseId, Duration duration) {
        List<OperationLog> logs = this.operationLogRepository.findLogsByHorseSince(horseId, DateUtils.futureDurationOffset(duration.negated()));
        List<Integer> operationIds = logs.stream().map(OperationLog::getOperationId).distinct().toList();
        return this.operationRepository.findByKeys(operationIds);
    }

    @Override
    public Optional<Date> getTimeOperationWasLastPerformed(int horseId, int operationId) {
        Optional<OperationLog> mostRecent = this.operationLogRepository.findMostRecentLogForOperationAndHorse(operationId, horseId);
        return mostRecent.map(OperationLog::getTimeStamp).map(Date::new);
    }

    @Override
    public Integer getCountOfOperationForHorseInDuration(int horseId, int operationId, Duration duration) {
        return this.operationLogRepository.getCountOfOperationSince(horseId, operationId, DateUtils.futureDurationOffset(duration.negated()));
    }
}

