/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.permission;

import com.equestricraft.common.ReflectionHelper;
import com.equestricraft.core.permission.PermissionException;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.logging.Log;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public abstract class PermissionChecker {
    private static final PermissionChecker permissionChecker = PermissionChecker.createPermissionChecker();
    private static final Log log = Log.getLogger(PermissionChecker.class.getName());

    private static PermissionChecker createPermissionChecker() {
        List<Class<PermissionChecker>> impls = ReflectionHelper.scanClassesExtendingType(PermissionChecker.class);
        Class impl = (Class)impls.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find an implementation of PermissionChecker"));
        try {
            return (PermissionChecker)impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new IllegalArgumentException("Error with PermissionChecker implementation");
        }
    }

    public static boolean doesPlayerHavePermission(ECPlayer player, String permission) {
        if (player.isOnline()) {
            return permissionChecker.doesPlayerHavePermissionImpl(player, permission);
        }
        return false;
    }

    public static void ensurePlayerHasPermission(ECPlayer player, String permission) {
        if (!PermissionChecker.doesPlayerHavePermission(player, permission)) {
            throw new PermissionException();
        }
    }

    public static void givePermissionToPlayer(ECPlayer player, String permission) {
        if (player.isOnline()) {
            permissionChecker.givePermissionToPlayerImpl(player, permission);
        } else {
            log.warn("Attempted to give permission node {} to offline player {}", (Object)permission, (Object)player.getIgn());
        }
    }

    public static void takePermissionFromPlayer(ECPlayer player, String permission) {
        if (player.isOnline()) {
            permissionChecker.takePermissionFromPlayerImpl(player, permission);
        } else {
            log.warn("Attempted to take permission node {} from offline player {}", (Object)permission, (Object)player.getIgn());
        }
    }

    protected abstract boolean doesPlayerHavePermissionImpl(ECPlayer var1, String var2);

    protected abstract void givePermissionToPlayerImpl(ECPlayer var1, String var2);

    protected abstract void takePermissionFromPlayerImpl(ECPlayer var1, String var2);
}

