/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.api.common.APIAttributesDto;
import com.equestricraft.api.common.APIEntityLocationDto;
import com.equestricraft.api.common.APIHorseDto;
import com.equestricraft.api.common.APIPlayerCharactersDto;
import com.equestricraft.api.common.APIPlayerCinematicCameraDto;
import com.equestricraft.api.common.APIPlayerCollectablesDto;
import com.equestricraft.api.common.APIPlayerDiscoverLocationsDto;
import com.equestricraft.api.common.APIPlayerDisplayNameDto;
import com.equestricraft.api.common.APIPlayerDonatorDto;
import com.equestricraft.api.common.APIPlayerDto;
import com.equestricraft.api.common.APIPlayerEconomyDto;
import com.equestricraft.api.common.APIPlayerEffectsDto;
import com.equestricraft.api.common.APIPlayerFactionDto;
import com.equestricraft.api.common.APIPlayerHonorDto;
import com.equestricraft.api.common.APIPlayerHorseLogsDto;
import com.equestricraft.api.common.APIPlayerHorsesDto;
import com.equestricraft.api.common.APIPlayerInductionMode;
import com.equestricraft.api.common.APIPlayerInventoryDto;
import com.equestricraft.api.common.APIPlayerJobDto;
import com.equestricraft.api.common.APIPlayerLeaderboardsDto;
import com.equestricraft.api.common.APIPlayerMenusDto;
import com.equestricraft.api.common.APIPlayerNicknameDto;
import com.equestricraft.api.common.APIPlayerPermissionDto;
import com.equestricraft.api.common.APIPlayerPlotsDto;
import com.equestricraft.api.common.APIPlayerProgressionDto;
import com.equestricraft.api.common.APIPlayerQuestsDto;
import com.equestricraft.api.common.APIPlayerRideDto;
import com.equestricraft.api.common.APIPlayerRideStyleDto;
import com.equestricraft.api.common.APIPlayerServerRulesDto;
import com.equestricraft.api.common.APIPlayerShopsDto;
import com.equestricraft.api.common.APIPlayerSkillDto;
import com.equestricraft.api.common.APIPlayerTokensDto;
import com.equestricraft.api.common.APIPlayerUniversityDto;
import com.equestricraft.core.attribute.APIAttributesDtoImpl;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.player.APIPlayerDisplayNameDtoImpl;
import com.equestricraft.core.player.APIPlayerEconomyDtoImpl;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.character.APIPlayerCharactersDtoImpl;
import com.equestricraft.core.player.cinematiccamera.APIPlayerCinematicCameraDtoImpl;
import com.equestricraft.core.player.collectables.APIPlayerCollectablesDtoImpl;
import com.equestricraft.core.player.discoverlocation.APIPlayerDiscoverLocationsDtoImpl;
import com.equestricraft.core.player.donator.APIPlayerDonatorDtoImpl;
import com.equestricraft.core.player.effect.APIPlayerEffectsDtoImpl;
import com.equestricraft.core.player.faction.APIPlayerFactionDtoImpl;
import com.equestricraft.core.player.faction.PlayerFactionAccessor;
import com.equestricraft.core.player.honor.APIPlayerHonorDtoImpl;
import com.equestricraft.core.player.horse.APIPlayerHorsesDtoImpl;
import com.equestricraft.core.player.horselogs.APIPlayerHorseLogsDtoImpl;
import com.equestricraft.core.player.induction.APIPlayerInductionModeImpl;
import com.equestricraft.core.player.inventory.APIPlayerInventoryDtoImpl;
import com.equestricraft.core.player.job.APIPlayerJobDtoImpl;
import com.equestricraft.core.player.leaderboard.APIPlayerLeaderboardsDtoImpl;
import com.equestricraft.core.player.location.APIPlayerLocation;
import com.equestricraft.core.player.menus.APIPlayerMenusDtoImpl;
import com.equestricraft.core.player.nickname.APIPlayerNicknameDtoImpl;
import com.equestricraft.core.player.permission.APIPlayerPermissionDtoImpl;
import com.equestricraft.core.player.plot.APIPlayerPlotsDtoImpl;
import com.equestricraft.core.player.progression.APIPlayerProgressionDtoImpl;
import com.equestricraft.core.player.quest.APIPlayerQuestsDtoImpl;
import com.equestricraft.core.player.ride.APIPlayerRideDtoImpl;
import com.equestricraft.core.player.ridestyle.APIPlayerRideStyleDtoImpl;
import com.equestricraft.core.player.serverrules.APIPlayerServerRulesDtoImpl;
import com.equestricraft.core.player.shop.APIPlayerShopsDtoImpl;
import com.equestricraft.core.player.skill.APIPlayerSkillDtoImpl;
import com.equestricraft.core.player.token.APIPlayerTokensDtoImpl;
import com.equestricraft.core.player.university.APIPlayerUniversityDtoImpl;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;

public class APIPlayerDtoImpl
implements APIPlayerDto {
    private final CorePlayer corePlayer;

    public APIPlayerDtoImpl(CorePlayer corePlayer) {
        this.corePlayer = corePlayer;
    }

    @Override
    public int getId() {
        return this.corePlayer.getId();
    }

    @Override
    public UUID getAccountUuid() {
        return this.corePlayer.getAccountUuid();
    }

    @Override
    public String getIgn() {
        return this.corePlayer.getIgn();
    }

    @Override
    public Date getFirstSeen() {
        return this.corePlayer.getFirstSeen();
    }

    @Override
    public Date getLastSeen() {
        return this.corePlayer.getLastSeen();
    }

    @Override
    public long getPlaytime() {
        return this.corePlayer.getPlaytime();
    }

    @Override
    public int getXp() {
        return this.corePlayer.getXp();
    }

    @Override
    public APIHorseDto getSelectedHorse() {
        Optional<EQHorse> selectedHorse = this.corePlayer.getHorses().getSelected();
        return selectedHorse.map(APIHorseDtoImpl::new).orElse(null);
    }

    @Override
    public APIAttributesDto getAttributes() {
        return new APIAttributesDtoImpl(this.corePlayer.getAttributes());
    }

    @Override
    public APIPlayerEconomyDto getEconomy() {
        return new APIPlayerEconomyDtoImpl(this.corePlayer.getEconomy());
    }

    @Override
    public APIPlayerUniversityDto getUniversity() {
        return new APIPlayerUniversityDtoImpl(this.corePlayer.getUniversity());
    }

    @Override
    public APIPlayerJobDto getJob() {
        return new APIPlayerJobDtoImpl(this.corePlayer.getJob());
    }

    @Override
    public APIPlayerFactionDto getFaction() {
        PlayerFactionAccessor faction = this.corePlayer.getFaction();
        return new APIPlayerFactionDtoImpl(faction);
    }

    @Override
    public APIPlayerProgressionDto getProgression() {
        return new APIPlayerProgressionDtoImpl(this.corePlayer.getProgression());
    }

    @Override
    public boolean sendMessage(String message) {
        return this.corePlayer.sendMessage(message);
    }

    @Override
    public boolean notify(String message) {
        return this.corePlayer.notify(message);
    }

    @Override
    public APIPlayerSkillDto getSkills() {
        return new APIPlayerSkillDtoImpl(this.corePlayer.getSkills());
    }

    @Override
    public APIPlayerRideDto getRide() {
        return new APIPlayerRideDtoImpl(this.corePlayer.getRideTime());
    }

    @Override
    public APIPlayerServerRulesDto getServerRules() {
        return new APIPlayerServerRulesDtoImpl(this.corePlayer);
    }

    @Override
    public APIPlayerInductionMode getInductionMode() {
        return new APIPlayerInductionModeImpl(this.corePlayer.getInductionMode());
    }

    @Override
    public APIPlayerRideStyleDto getRideStyle() {
        return new APIPlayerRideStyleDtoImpl(this.corePlayer);
    }

    @Override
    public APIPlayerNicknameDto getNickname() {
        return new APIPlayerNicknameDtoImpl(this.corePlayer);
    }

    @Override
    public APIPlayerTokensDto getTokens() {
        return new APIPlayerTokensDtoImpl(this.corePlayer.getTokens());
    }

    @Override
    public APIPlayerDisplayNameDto getDisplayName() {
        return new APIPlayerDisplayNameDtoImpl(this.corePlayer);
    }

    @Override
    public APIPlayerHonorDto getHonor() {
        return new APIPlayerHonorDtoImpl(this.corePlayer.getHonor());
    }

    @Override
    public APIPlayerCharactersDto getCharacters() {
        return new APIPlayerCharactersDtoImpl(this.corePlayer.getCharacters());
    }

    @Override
    public APIHorseDto getRidingHorse() {
        Optional<EQHorse> horse = this.corePlayer.getHorses().getRiding();
        return horse.map(APIHorseDtoImpl::new).orElse(null);
    }

    @Override
    public APIPlayerPermissionDto getPermission() {
        return new APIPlayerPermissionDtoImpl(this.corePlayer.getPermission());
    }

    @Override
    public APIPlayerDonatorDto getDonator() {
        return new APIPlayerDonatorDtoImpl(this.corePlayer.getDonator());
    }

    @Override
    public APIPlayerCollectablesDto getCollectables() {
        return new APIPlayerCollectablesDtoImpl(this.corePlayer.getCollectables());
    }

    @Override
    public APIPlayerDiscoverLocationsDto getDiscoverLocations() {
        return new APIPlayerDiscoverLocationsDtoImpl(this.corePlayer.getDiscoverLocations());
    }

    @Override
    public APIPlayerHorseLogsDto getHorseLogs() {
        return new APIPlayerHorseLogsDtoImpl(this.corePlayer.getHorseLogs());
    }

    @Override
    public APIPlayerHorsesDto getHorses() {
        return new APIPlayerHorsesDtoImpl(this.corePlayer.getHorses());
    }

    @Override
    public APIPlayerLeaderboardsDto getLeaderboards() {
        return new APIPlayerLeaderboardsDtoImpl(this.corePlayer.getLeaderboards());
    }

    @Override
    public APIEntityLocationDto getLocation() {
        return new APIPlayerLocation(this.corePlayer.getLocation());
    }

    @Override
    public APIPlayerCinematicCameraDto getCinematicCamera() {
        return new APIPlayerCinematicCameraDtoImpl(this.corePlayer.getCinematicCamera());
    }

    @Override
    public APIPlayerEffectsDto getEffects() {
        return new APIPlayerEffectsDtoImpl(this.corePlayer.getEffects());
    }

    @Override
    public APIPlayerMenusDto getMenus() {
        return new APIPlayerMenusDtoImpl(this.corePlayer.getMenus());
    }

    @Override
    public APIPlayerShopsDto getShops() {
        return new APIPlayerShopsDtoImpl(this.corePlayer.getShops());
    }

    @Override
    public APIPlayerQuestsDto getQuests() {
        return new APIPlayerQuestsDtoImpl(this.corePlayer.getQuests());
    }

    @Override
    public APIPlayerPlotsDto getPlots() {
        return new APIPlayerPlotsDtoImpl(this.corePlayer.getPlots());
    }

    @Override
    public APIPlayerInventoryDto getInventory() {
        return new APIPlayerInventoryDtoImpl(this.corePlayer.getInventory());
    }

    public CorePlayer getCorePlayer() {
        return this.corePlayer;
    }

    public String toString() {
        return this.getDisplayName().getBasic();
    }
}

