/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.api.common.APIDualAccountEconomyResponse;
import com.equestricraft.api.common.APIEconomyRequestDto;
import com.equestricraft.api.common.APIEconomyTransferRequestDto;
import com.equestricraft.api.common.APIMoneyValueDto;
import com.equestricraft.api.common.APIPlayerDto;
import com.equestricraft.api.common.APIPlayerEconomyDto;
import com.equestricraft.api.common.APISingleAccountEconomyResponse;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.economy.APIDualAccountEconomyResponseImpl;
import com.equestricraft.core.economy.APISingleAccountEconomyResponseImpl;
import com.equestricraft.core.economy.DualAccountEconomyResponse;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyTransformer;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerEconomyAccessor;
import com.equestricraft.core.player.PlayerTransformer;
import groovy.lang.Closure;

public class APIPlayerEconomyDtoImpl
implements APIPlayerEconomyDto {
    @Service
    private static EconomyTransformer economyTransformer;
    @Service
    private static PlayerTransformer playerTransformer;
    private final PlayerEconomyAccessor playerEconomyAccessor;

    public APIPlayerEconomyDtoImpl(PlayerEconomyAccessor playerEconomyAccessor) {
        this.playerEconomyAccessor = playerEconomyAccessor;
    }

    @Override
    public APIMoneyValueDto getBalance() {
        return economyTransformer.toApiDto(this.playerEconomyAccessor.getBalance());
    }

    @Override
    public APISingleAccountEconomyResponse deposit(Closure<?> request) {
        APIEconomyRequestDto requestDetails = this.buildRequest(request);
        return this.deposit(requestDetails.getAmount(), requestDetails.getReason());
    }

    @Override
    public APISingleAccountEconomyResponse deposit(double amount, String reason) {
        SingleAccountEconomyResponse response = this.playerEconomyAccessor.deposit(amount, reason, "API");
        return new APISingleAccountEconomyResponseImpl(response, null);
    }

    @Override
    public APISingleAccountEconomyResponse withdraw(Closure<?> request) {
        APIEconomyRequestDto requestDetails = this.buildRequest(request);
        return this.withdraw(requestDetails.getAmount(), requestDetails.getReason());
    }

    @Override
    public APISingleAccountEconomyResponse withdraw(double amount, String reason) {
        try {
            SingleAccountEconomyResponse response = this.playerEconomyAccessor.withdraw(amount, reason, "API");
            return new APISingleAccountEconomyResponseImpl(response, null);
        }
        catch (EconomyException ex) {
            return new APISingleAccountEconomyResponseImpl(null, ex.getMessage());
        }
    }

    @Override
    public APIDualAccountEconomyResponse sendTo(Closure<?> request) {
        APIEconomyTransferRequestDto requestDetails = this.buildTransferRequest(request);
        return this.sendTo(requestDetails.getPlayer(), requestDetails.getAmount(), requestDetails.getReason());
    }

    @Override
    public APIDualAccountEconomyResponse sendTo(APIPlayerDto target, double amount, String reason) {
        CorePlayer targetPlayer = playerTransformer.fromDto(target);
        try {
            DualAccountEconomyResponse response = this.playerEconomyAccessor.sendTo(targetPlayer, amount, reason);
            return new APIDualAccountEconomyResponseImpl(response, null);
        }
        catch (EconomyException ex) {
            return new APIDualAccountEconomyResponseImpl(null, ex.getMessage());
        }
    }

    private APIEconomyRequestDto buildRequest(Closure<?> closure) {
        APIEconomyRequestDto request = new APIEconomyRequestDto();
        closure.setDelegate(request);
        closure.call();
        return request;
    }

    private APIEconomyTransferRequestDto buildTransferRequest(Closure<?> closure) {
        APIEconomyTransferRequestDto request = new APIEconomyTransferRequestDto();
        closure.setDelegate(request);
        closure.call();
        return request;
    }

    public String toString() {
        return this.getBalance().toString();
    }
}

