/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.base.text.TextItem;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.DonatorLevel;
import com.equestricraft.common.RideStyle;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerAdapter;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.nickname.Nickname;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class CorePlayer
extends PlayerAdapter
implements RepositoryEntity<Integer>,
ECPlayer {
    private int id;
    private final UUID accountUuid;
    private String ign;
    private Date firstSeen;
    private Date lastSeen;
    private String ipAddress;
    private long playtime;
    private Nickname nickname;
    private int nicknameTokens;
    private int horseCreateTokens;
    private Integer activeTagId;
    private int xp;
    private boolean finishedInduction;
    private boolean donator;
    private DonatorLevel donatorLevel;
    private Integer jobId;
    private Integer universityHouseId;
    private Date universityHouseJoinDate;
    private boolean clubPlus;
    private Long discordAccountId;
    private String discordNicknameSeparator;
    private Date agreedToRulesTime;
    private Integer factionId;
    private int factionXp;
    private RideStyle rideStylePreference;
    private int honorScore;
    private String customJoinMessage;
    private String customLeaveMessage;
    private Date lastDailyJoinRewardTime;
    private int dailyJoinDayStreak;
    private boolean glowAccess;
    private final Map<Class<? extends ECPlayer>, ECPlayer> map = new HashMap<Class<? extends ECPlayer>, ECPlayer>();

    public CorePlayer(int id, UUID accountUuid, String ign, Date firstSeen, Date lastSeen, String ipAddress, long playtime, Nickname nickname, int nicknameTokens, int horseCreateTokens, Integer activeTagId, int xp, boolean finishedInduction, boolean donator, DonatorLevel donatorLevel, Integer jobId, Integer universityHouseId, Date universityHouseJoinDate, boolean clubPlus, Long discordAccountId, String discordNicknameSeparator, Date agreedToRulesTime, Integer factionId, int factionXp, RideStyle rideStylePreference, int honorScore, String customJoinMessage, String customLeaveMessage, Date lastDailyJoinRewardTime, int dailyJoinDayStreak, boolean glowAccess) {
        this.id = id;
        this.accountUuid = accountUuid;
        this.ign = ign;
        this.firstSeen = firstSeen;
        this.lastSeen = lastSeen;
        this.ipAddress = ipAddress;
        this.playtime = playtime;
        this.nickname = nickname;
        this.nicknameTokens = nicknameTokens;
        this.horseCreateTokens = horseCreateTokens;
        this.activeTagId = activeTagId;
        this.xp = xp;
        this.finishedInduction = finishedInduction;
        this.donator = donator;
        this.donatorLevel = donatorLevel;
        this.jobId = jobId;
        this.universityHouseId = universityHouseId;
        this.universityHouseJoinDate = universityHouseJoinDate;
        this.clubPlus = clubPlus;
        this.discordAccountId = discordAccountId;
        this.discordNicknameSeparator = discordNicknameSeparator;
        this.agreedToRulesTime = agreedToRulesTime;
        this.factionId = factionId;
        this.factionXp = factionXp;
        this.rideStylePreference = rideStylePreference;
        this.honorScore = honorScore;
        this.customJoinMessage = customJoinMessage;
        this.customLeaveMessage = customLeaveMessage;
        this.lastDailyJoinRewardTime = lastDailyJoinRewardTime;
        this.dailyJoinDayStreak = dailyJoinDayStreak;
        this.glowAccess = glowAccess;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public UUID getAccountUuid() {
        return this.accountUuid;
    }

    @Override
    public String getIgn() {
        return this.ign;
    }

    public void setIgn(String ign) {
        this.ign = ign;
    }

    public Date getFirstSeen() {
        return this.firstSeen;
    }

    public void setFirstSeen(Date firstSeen) {
        this.firstSeen = firstSeen;
    }

    public Date getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(Date lastSeen) {
        this.lastSeen = lastSeen;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public long getPlaytime() {
        return this.playtime;
    }

    public void setPlaytime(long playtime) {
        this.playtime = playtime;
    }

    @Override
    public Optional<Nickname> getNickname() {
        return Optional.ofNullable(this.nickname);
    }

    public void setNickname(Nickname nickname) {
        this.nickname = nickname;
    }

    @Override
    public TextItem getDisplayName() {
        return this.getNickname().map(Nickname::getTextItem).orElse(new TextItem(this.ign));
    }

    public int getNicknameTokens() {
        return this.nicknameTokens;
    }

    public void setNicknameTokens(int nicknameTokens) {
        this.nicknameTokens = nicknameTokens;
    }

    public int getHorseCreateTokens() {
        return this.horseCreateTokens;
    }

    public void setHorseCreateTokens(int horseCreateTokens) {
        this.horseCreateTokens = horseCreateTokens;
    }

    public Integer getActiveTagId() {
        return this.activeTagId;
    }

    public void setActiveTagId(Integer activeTagId) {
        this.activeTagId = activeTagId;
    }

    public int getXp() {
        return this.xp;
    }

    public void setXp(int xp) {
        this.xp = xp;
    }

    public boolean isFinishedInduction() {
        return this.finishedInduction;
    }

    public void setFinishedInduction(boolean finishedInduction) {
        this.finishedInduction = finishedInduction;
    }

    public boolean isDonator() {
        return this.donator;
    }

    public void setDonator(boolean donator) {
        this.donator = donator;
    }

    public DonatorLevel getDonatorLevel() {
        return this.donatorLevel;
    }

    public void setDonatorLevel(DonatorLevel donatorLevel) {
        this.donatorLevel = donatorLevel;
    }

    public Integer getJobId() {
        return this.jobId;
    }

    public void setJobId(Integer jobId) {
        this.jobId = jobId;
    }

    public Integer getUniversityHouseId() {
        return this.universityHouseId;
    }

    public void setUniversityHouseId(Integer universityHouseId) {
        this.universityHouseId = universityHouseId;
    }

    public Date getUniversityHouseJoinDate() {
        return this.universityHouseJoinDate;
    }

    public void setUniversityHouseJoinDate(Date universityHouseJoinDate) {
        this.universityHouseJoinDate = universityHouseJoinDate;
    }

    public boolean isClubPlus() {
        return this.clubPlus;
    }

    public void setClubPlus(boolean clubPlus) {
        this.clubPlus = clubPlus;
    }

    public Long getDiscordAccountId() {
        return this.discordAccountId;
    }

    public void setDiscordAccountId(Long discordAccountId) {
        this.discordAccountId = discordAccountId;
    }

    public String getDiscordNicknameSeparator() {
        return this.discordNicknameSeparator;
    }

    public void setDiscordNicknameSeparator(String discordNicknameSeparator) {
        this.discordNicknameSeparator = discordNicknameSeparator;
    }

    public Date getAgreedToRulesTime() {
        return this.agreedToRulesTime;
    }

    public void setAgreedToRulesTime(Date agreedToRulesTime) {
        this.agreedToRulesTime = agreedToRulesTime;
    }

    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer factionId) {
        this.factionId = factionId;
    }

    public int getFactionXp() {
        return this.factionXp;
    }

    public void setFactionXp(int factionXp) {
        this.factionXp = factionXp;
    }

    public RideStyle getRideStylePreference() {
        return this.rideStylePreference;
    }

    public void setRideStylePreference(RideStyle rideStylePreference) {
        this.rideStylePreference = rideStylePreference;
    }

    public int getHonorScore() {
        return this.honorScore;
    }

    public void setHonorScore(int honorScore) {
        this.honorScore = honorScore;
    }

    public String getCustomJoinMessage() {
        return this.customJoinMessage;
    }

    public void setCustomJoinMessage(String customJoinMessage) {
        this.customJoinMessage = customJoinMessage;
    }

    public String getCustomLeaveMessage() {
        return this.customLeaveMessage;
    }

    public void setCustomLeaveMessage(String customLeaveMessage) {
        this.customLeaveMessage = customLeaveMessage;
    }

    public Date getLastDailyJoinRewardTime() {
        return this.lastDailyJoinRewardTime;
    }

    public void setLastDailyJoinRewardTime(Date lastDailyJoinRewardTime) {
        this.lastDailyJoinRewardTime = lastDailyJoinRewardTime;
    }

    public int getDailyJoinDayStreak() {
        return this.dailyJoinDayStreak;
    }

    public void setDailyJoinDayStreak(int dailyJoinDayStreak) {
        this.dailyJoinDayStreak = dailyJoinDayStreak;
    }

    public boolean isGlowAccess() {
        return this.glowAccess;
    }

    public void setGlowAccess(boolean glowAccess) {
        this.glowAccess = glowAccess;
    }

    @Override
    public CorePlayer getCorePlayer() {
        return this;
    }

    public boolean hasOnlineData() {
        return !this.map.isEmpty();
    }

    public <T extends ECPlayer> Optional<T> getECPlayerData(Class<? extends T> clazz) {
        return Optional.ofNullable(this.map.get(clazz));
    }

    public <T extends ECPlayer> T addECPlayerData(T data) {
        return (T)this.map.put(data.getClass(), data);
    }

    public void clearECPlayerData() {
        this.map.clear();
    }

    @Override
    public void save() {
        Services.getService(PlayerRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorePlayer that = (CorePlayer)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return this.ign;
    }
}

