/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.text.TextItem;
import com.equestricraft.core.message.MessageSender;
import com.equestricraft.core.permission.PermissionChecker;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerEconomyAccessor;
import com.equestricraft.core.player.achievement.PlayerAchievementAccessor;
import com.equestricraft.core.player.afk.PlayerAfkAccessor;
import com.equestricraft.core.player.alert.PlayerAlertAccessor;
import com.equestricraft.core.player.attribute.PlayerAttributesAccessor;
import com.equestricraft.core.player.character.PlayerCharacterAccessor;
import com.equestricraft.core.player.chattag.PlayerChatTagAccessor;
import com.equestricraft.core.player.cinematiccamera.PlayerCinematicCameraAccessor;
import com.equestricraft.core.player.club.PlayerClubAccessor;
import com.equestricraft.core.player.collectables.PlayerCollectableAccessor;
import com.equestricraft.core.player.confirmation.PlayerConfirmationAccessor;
import com.equestricraft.core.player.discoverlocation.PlayerDiscoverLocationAccessor;
import com.equestricraft.core.player.donator.PlayerDonatorAccessor;
import com.equestricraft.core.player.effect.PlayerEffectAccessor;
import com.equestricraft.core.player.faction.PlayerFactionAccessor;
import com.equestricraft.core.player.glow.PlayerGlowAccessor;
import com.equestricraft.core.player.honor.PlayerHonorAccessor;
import com.equestricraft.core.player.horse.PlayerHorseAccessor;
import com.equestricraft.core.player.horselogs.PlayerHorseLogAccessor;
import com.equestricraft.core.player.induction.PlayerInductionAccessor;
import com.equestricraft.core.player.inventory.PlayerInventoryAccessor;
import com.equestricraft.core.player.job.PlayerJobAccessor;
import com.equestricraft.core.player.leaderboard.PlayerLeaderboardAccessor;
import com.equestricraft.core.player.location.PlayerLocationAccessor;
import com.equestricraft.core.player.menus.PlayerMenusAccessor;
import com.equestricraft.core.player.message.PrivateMessageAccessor;
import com.equestricraft.core.player.nickname.Nickname;
import com.equestricraft.core.player.notification.NotificationHelper;
import com.equestricraft.core.player.permission.PlayerPermissionAccessor;
import com.equestricraft.core.player.plot.PlayerPlotAccessor;
import com.equestricraft.core.player.progression.PlayerProgressionAccessor;
import com.equestricraft.core.player.quest.PlayerQuestAccessor;
import com.equestricraft.core.player.ride.PlayerRideTimeAccessor;
import com.equestricraft.core.player.shop.PlayerShopsAccessor;
import com.equestricraft.core.player.skill.PlayerSkillAccessor;
import com.equestricraft.core.player.token.PlayerTokenAccessor;
import com.equestricraft.core.player.university.PlayerUniversityAccessor;
import com.equestricraft.core.response.ResponseHandler;
import com.equestricraft.core.utilities.BossBarHelper;
import com.equestricraft.core.utilities.ChatDisabledHelper;
import com.equestricraft.core.utilities.PacketHelper;
import com.equestricraft.core.utilities.SpeedLimitHelper;
import com.equestricraft.core.utilities.TitleSender;
import com.equestricraft.core.utilities.ToastSender;
import java.util.Optional;
import java.util.UUID;

public interface ECPlayer {
    default public int getId() {
        return this.getCorePlayer().getId();
    }

    default public UUID getAccountUuid() {
        return this.getCorePlayer().getAccountUuid();
    }

    default public String getIgn() {
        return this.getCorePlayer().getIgn();
    }

    default public Optional<Nickname> getNickname() {
        return this.getCorePlayer().getNickname();
    }

    default public TextItem getDisplayName() {
        return this.getCorePlayer().getDisplayName();
    }

    public CorePlayer getCorePlayer();

    default public boolean isOnline() {
        return this.getCorePlayer().hasOnlineData();
    }

    default public <T extends ECPlayer> T require(Class<? extends T> clazz) {
        return (T)((ECPlayer)this.getCorePlayer().getECPlayerData(clazz).orElseThrow());
    }

    default public <T extends ECPlayer> Optional<T> provideData(T data) {
        return Optional.ofNullable(this.getCorePlayer().addECPlayerData(data));
    }

    default public boolean sendMessage(String message) {
        return MessageSender.sendMessageToPlayer(this, message);
    }

    default public boolean sendMessage(TextItem message) {
        return MessageSender.sendMessageToPlayer(this, message);
    }

    default public boolean sendToast(String message) {
        return ToastSender.sendToastToPlayer(this, message);
    }

    default public boolean sendToast(TextItem message) {
        return ToastSender.sendToastToPlayer(this, message);
    }

    default public boolean notify(String message) {
        return NotificationHelper.notifyPlayer(this, message);
    }

    default public void sendTitle(String title, String subtitle) {
        TitleSender.sendTitleToPlayer(this, title, subtitle);
    }

    default public void sendTitle(String title, String subtitle, int fadeInTicks, int displayTicks, int fadeOutTicks) {
        TitleSender.sendTitleToPlayer(this, title, subtitle, fadeInTicks, displayTicks, fadeOutTicks);
    }

    default public void sendActionBar(String text) {
        TitleSender.sendActionBarToPlayer(this, text);
    }

    default public void setBossBarText(String text) {
        BossBarHelper.setBossBarText(this, text);
    }

    default public void clearBossBarText() {
        BossBarHelper.clearBossBar(this);
    }

    default public boolean hasPermission(String permission) {
        return PermissionChecker.doesPlayerHavePermission(this, permission);
    }

    default public void showResponse(Response response) {
        ResponseHandler.handleResponse(this, response);
    }

    default public void showResponseIfSuccess(Response response) {
        if (response.isSuccess()) {
            ResponseHandler.handleResponse(this, response);
        }
    }

    default public void showResponseIfFail(Response response) {
        if (!response.isSuccess()) {
            ResponseHandler.handleResponse(this, response);
        }
    }

    default public <P> boolean sendPacket(P packet) {
        return PacketHelper.sendPacketToPlayer(this, packet);
    }

    default public boolean chatDisabled() {
        return ChatDisabledHelper.isChatDisabled(this);
    }

    default public Optional<Float> getSpeedLimit() {
        return SpeedLimitHelper.getSpeedLimit(this);
    }

    default public PlayerAttributesAccessor getAttributes() {
        return this.getCorePlayer().getAttributes();
    }

    default public PlayerJobAccessor getJob() {
        return this.getCorePlayer().getJob();
    }

    default public PlayerFactionAccessor getFaction() {
        return this.getCorePlayer().getFaction();
    }

    default public PlayerEconomyAccessor getEconomy() {
        return this.getCorePlayer().getEconomy();
    }

    default public PlayerUniversityAccessor getUniversity() {
        return this.getCorePlayer().getUniversity();
    }

    default public PlayerProgressionAccessor getProgression() {
        return this.getCorePlayer().getProgression();
    }

    default public PlayerChatTagAccessor getChatTag() {
        return this.getCorePlayer().getChatTag();
    }

    default public PlayerSkillAccessor getSkills() {
        return this.getCorePlayer().getSkills();
    }

    default public PlayerRideTimeAccessor getRideTime() {
        return this.getCorePlayer().getRideTime();
    }

    default public PlayerTokenAccessor getTokens() {
        return this.getCorePlayer().getTokens();
    }

    default public PlayerHonorAccessor getHonor() {
        return this.getCorePlayer().getHonor();
    }

    default public PlayerCharacterAccessor getCharacters() {
        return this.getCorePlayer().getCharacters();
    }

    default public PlayerPermissionAccessor getPermission() {
        return this.getCorePlayer().getPermission();
    }

    default public PlayerDonatorAccessor getDonator() {
        return this.getCorePlayer().getDonator();
    }

    default public PlayerGlowAccessor getGlow() {
        return this.getCorePlayer().getGlow();
    }

    default public PlayerAchievementAccessor getAchievements() {
        return this.getCorePlayer().getAchievements();
    }

    default public PlayerAfkAccessor getAfk() {
        return this.getCorePlayer().getAfk();
    }

    default public PlayerDiscoverLocationAccessor getDiscoverLocations() {
        return this.getCorePlayer().getDiscoverLocations();
    }

    default public PlayerInductionAccessor getInductionMode() {
        return this.getCorePlayer().getInductionMode();
    }

    default public PlayerPlotAccessor getPlots() {
        return this.getCorePlayer().getPlots();
    }

    default public PlayerHorseAccessor getHorses() {
        return this.getCorePlayer().getHorses();
    }

    default public PrivateMessageAccessor getPrivateMessages() {
        return this.getCorePlayer().getPrivateMessages();
    }

    default public PlayerLocationAccessor getLocation() {
        return this.getCorePlayer().getLocation();
    }

    default public PlayerClubAccessor getClub() {
        return this.getCorePlayer().getClub();
    }

    default public PlayerCollectableAccessor getCollectables() {
        return this.getCorePlayer().getCollectables();
    }

    default public PlayerHorseLogAccessor getHorseLogs() {
        return this.getCorePlayer().getHorseLogs();
    }

    default public PlayerLeaderboardAccessor getLeaderboards() {
        return this.getCorePlayer().getLeaderboards();
    }

    default public PlayerCinematicCameraAccessor getCinematicCamera() {
        return this.getCorePlayer().getCinematicCamera();
    }

    default public PlayerEffectAccessor getEffects() {
        return this.getCorePlayer().getEffects();
    }

    default public PlayerMenusAccessor getMenus() {
        return this.getCorePlayer().getMenus();
    }

    default public PlayerShopsAccessor getShops() {
        return this.getCorePlayer().getShops();
    }

    default public PlayerQuestAccessor getQuests() {
        return this.getCorePlayer().getQuests();
    }

    default public PlayerConfirmationAccessor getConfirmation() {
        return this.getCorePlayer().getConfirmation();
    }

    default public PlayerAlertAccessor getAlert() {
        return this.getCorePlayer().getAlert();
    }

    default public PlayerInventoryAccessor getInventory() {
        return this.getCorePlayer().getInventory();
    }
}

