/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerNotOnlineException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public class OnlinePlayerCache
extends Repository<CacheEntry, Integer> {
    private static final OnlinePlayerCache instance = new OnlinePlayerCache();

    public static OnlinePlayerCache getInstance() {
        return instance;
    }

    private OnlinePlayerCache() {
    }

    @Override
    protected Function<CacheEntry, Object> getIndexFunction() {
        return c -> c.player().getIgn().toLowerCase();
    }

    @Override
    public void add(ECPlayer player) {
        this.add(new CacheEntry(player));
    }

    public boolean isPlayerOnline(int internalId) {
        return this.getPlayer(internalId).isPresent();
    }

    public boolean isPlayerOnline(String ign) {
        return this.getPlayer(ign).isPresent();
    }

    public Optional<ECPlayer> getPlayer(UUID uuid) {
        return this.findSingleByPredicates((T c) -> c.player().getAccountUuid().equals(uuid)).map(CacheEntry::player);
    }

    public Optional<ECPlayer> getPlayer(int internalId) {
        return this.findByKeyIfExists(internalId).map(CacheEntry::player);
    }

    public Optional<ECPlayer> getPlayer(String ign) {
        return this.findByIndexKeyIfExists(ign.toLowerCase()).map(CacheEntry::player);
    }

    public ECPlayer requirePlayer(UUID uuid) {
        return this.getPlayer(uuid).orElseThrow(PlayerNotOnlineException::new);
    }

    public ECPlayer requirePlayer(int internalId) {
        return this.getPlayer(internalId).orElseThrow(PlayerNotOnlineException::new);
    }

    public ECPlayer requirePlayer(String ign) {
        return this.getPlayer(ign).orElseThrow(PlayerNotOnlineException::new);
    }

    public List<ECPlayer> getAllPlayers() {
        return this.findAll().stream().map(CacheEntry::player).toList();
    }

    public int getOnlinePlayerCount() {
        return this.findAll().size();
    }

    public void removePlayer(int internalId) {
        this.removeByKey(internalId);
    }

    public record CacheEntry(ECPlayer player) implements RepositoryEntity<Integer>
    {
        @Override
        public Integer getKey() {
            return this.player.getId();
        }
    }
}

