/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.core.player.ECPlayer;
import java.util.Optional;

public class PlayerContext {
    private final ECPlayer player;
    protected static final ThreadLocal<PlayerContext> contextLocal = new ThreadLocal();

    protected PlayerContext(ECPlayer player) {
        this.player = player;
    }

    public static ECPlayer getPlayer() {
        return PlayerContext.require().player;
    }

    public static PlayerContext require() {
        return PlayerContext.get().orElseThrow();
    }

    public static Optional<PlayerContext> get() {
        PlayerContext context = contextLocal.get();
        return Optional.ofNullable(context);
    }

    public static void set(ECPlayer player) {
        contextLocal.set(new PlayerContext(player));
    }

    public static void clear() {
        contextLocal.remove();
    }
}

