/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.DonatorLevel;
import com.equestricraft.common.PlayerDataUpdateMessage;
import com.equestricraft.common.RideStyle;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerDataUpdateProcessor;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.chattag.access.ChatTagPlayerAccessSession;
import com.equestricraft.core.player.nickname.Nickname;
import com.equestricraft.logging.Log;
import java.util.Date;

public class PlayerDataUpdateProcessorImpl
implements PlayerDataUpdateProcessor {
    @Service
    private PlayerRepository playerRepository;
    @Service
    private ChatTagPlayerAccessSession chatTagPlayerAccessSession;
    private static final Log log = Log.getLogger(PlayerDataUpdateProcessorImpl.class.getName());

    @Override
    public void processUpdate(PlayerDataUpdateMessage message) {
        CorePlayer player = (CorePlayer)this.playerRepository.findByKey(message.getPlayerId());
        for (PlayerDataUpdateMessage.UpdateField fieldUpdate : message.getFieldUpdates()) {
            this.processFieldForPlayer(player, fieldUpdate.getFieldName(), fieldUpdate.getFieldValue());
        }
    }

    private void processFieldForPlayer(CorePlayer player, String fieldName, Object value) {
        switch (fieldName) {
            case "ign": {
                player.setIgn(value.toString());
                break;
            }
            case "firstSeen": {
                player.setFirstSeen(new Date((Long)value));
                break;
            }
            case "lastSeen": {
                player.setLastSeen((Date)value);
                break;
            }
            case "ipAddress": {
                player.setIpAddress(value.toString());
                break;
            }
            case "playTime": {
                player.setPlaytime((Long)value);
                break;
            }
            case "nickname": {
                player.setNickname(value != null ? Nickname.createNickname(value.toString()) : null);
                break;
            }
            case "nicknameTokens": {
                player.setNicknameTokens((Integer)value);
                break;
            }
            case "horseCreateTokens": {
                player.setHorseCreateTokens((Integer)value);
                break;
            }
            case "activeTagId": {
                player.setActiveTagId((Integer)value);
                break;
            }
            case "xp": {
                player.setXp((Integer)value);
                break;
            }
            case "finishedInduction": {
                player.setFinishedInduction((Boolean)value);
                break;
            }
            case "donator": {
                player.setDonator((Boolean)value);
                break;
            }
            case "donatorLevel": {
                player.setDonatorLevel((DonatorLevel)((Object)value));
                break;
            }
            case "jobId": {
                player.setJobId((Integer)value);
                break;
            }
            case "universityHouseId": {
                player.setUniversityHouseId((Integer)value);
                break;
            }
            case "universityHouseJoinDate": {
                player.setUniversityHouseJoinDate((Date)value);
                break;
            }
            case "clubPlus": {
                player.setClubPlus((Boolean)value);
                break;
            }
            case "discordAccountId": {
                player.setDiscordAccountId((Long)value);
                break;
            }
            case "discordNicknameSeparator": {
                player.setDiscordNicknameSeparator((String)value);
                break;
            }
            case "agreedToRulesTime": {
                player.setAgreedToRulesTime((Date)value);
                break;
            }
            case "factionId": {
                player.setFactionId((Integer)value);
                break;
            }
            case "factionXp": {
                player.setFactionXp((Integer)value);
                break;
            }
            case "rideStylePreference": {
                player.setRideStylePreference((RideStyle)((Object)value));
                break;
            }
            case "honorScore": {
                player.setHonorScore((Integer)value);
                break;
            }
            case "customJoinMessage": {
                player.setCustomJoinMessage((String)value);
                break;
            }
            case "customLeaveMessage": {
                player.setCustomLeaveMessage((String)value);
                break;
            }
            case "lastDailyJoinRewardTime": {
                player.setLastDailyJoinRewardTime((Date)value);
                break;
            }
            case "dailyJoinDayStreak": {
                player.setDailyJoinDayStreak((Integer)value);
                break;
            }
            case "add_chat_tag": {
                this.addChatTag(player, (Integer)value);
                break;
            }
            default: {
                log.warn("Unrecognised field on player data update: {}", (Object)fieldName);
            }
        }
    }

    private void addChatTag(CorePlayer player, Integer tagId) {
        this.chatTagPlayerAccessSession.grantPlayerAccessToTag(player, tagId);
    }
}

