/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.DonatorLevel;
import com.equestricraft.common.RideStyle;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.nickname.Nickname;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class PlayerDatabase
implements RepositoryDatasource<CorePlayer, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_ACCOUNT_UUID = "ACCOUNT_UUID";
    private static final String COLUMN_IGN = "IGN";
    private static final String COLUMN_FIRST_SEEN = "FIRST_SEEN";
    private static final String COLUMN_LAST_SEEN = "LAST_SEEN";
    private static final String COLUMN_IP_ADDRESS = "IP_ADDRESS";
    private static final String COLUMN_PLAYTIME = "PLAYTIME";
    private static final String COLUMN_NICKNAME = "NICKNAME";
    private static final String COLUMN_NICKNAME_TOKENS = "NICKNAME_TOKENS";
    private static final String COLUMN_HORSE_CREATE_TOKENS = "HORSE_CREATE_TOKENS";
    private static final String COLUMN_ACTIVE_TAG_ID = "ACTIVE_TAG_ID";
    private static final String COLUMN_XP = "XP";
    private static final String COLUMN_FINISHED_INDUCTION = "FINISHED_INDUCTION";
    private static final String COLUMN_DONATOR = "DONATOR";
    private static final String COLUMN_DONATOR_LEVEL = "DONATOR_LEVEL";
    private static final String COLUMN_JOB_ID = "JOB_ID";
    private static final String COLUMN_UNIVERSITY_HOUSE_ID = "UNIVERSITY_HOUSE_ID";
    private static final String COLUMN_UNIVERSITY_HOUSE_JOIN_DATE = "UNIVERSITY_HOUSE_JOIN_DATE";
    private static final String COLUMN_CLUB_PLUS = "CLUB_PLUS";
    private static final String COLUMN_DISCORD_ACCOUNT_ID = "DISCORD_ACCOUNT_ID";
    private static final String COLUMN_DISCORD_NICKNAME_SEPARATOR = "DISCORD_NICKNAME_SEPARATOR";
    private static final String COLUMN_AGREED_TO_RULES_TIME = "AGREED_TO_RULES_TIME";
    private static final String COLUMN_FACTION_ID = "FACTION_ID";
    private static final String COLUMN_FACTION_XP = "FACTION_XP";
    private static final String COLUMN_RIDE_STYLE_PREFERENCE = "RIDE_STYLE_PREFERENCE";
    private static final String COLUMN_HONOR_SCORE = "HONOR_SCORE";
    private static final String COLUMN_CUSTOM_JOIN_MESSAGE = "CUSTOM_JOIN_MESSAGE";
    private static final String COLUMN_CUSTOM_LEAVE_MESSAGE = "CUSTOM_LEAVE_MESSAGE";
    private static final String COLUMN_LAST_DAILY_JOIN_REWARD_TIME = "LAST_DAILY_JOIN_REWARD_TIME";
    private static final String COLUMN_DAILY_JOIN_DAY_STREAK = "DAILY_JOIN_DAY_STREAK";
    private static final String COLUMN_GLOW_ACCESS = "GLOW_ACCESS";

    @Override
    public void create(CorePlayer corePlayer) {
        Query.insertInto("PLAYER").columns(QueryColumn.column(COLUMN_ACCOUNT_UUID, corePlayer.getAccountUuid()), QueryColumn.column(COLUMN_IGN, corePlayer.getIgn()), QueryColumn.column(COLUMN_FIRST_SEEN, corePlayer.getFirstSeen()), QueryColumn.column(COLUMN_LAST_SEEN, corePlayer.getLastSeen()), QueryColumn.column(COLUMN_IP_ADDRESS, corePlayer.getIpAddress()), QueryColumn.column(COLUMN_PLAYTIME, corePlayer.getPlaytime()), QueryColumn.column(COLUMN_NICKNAME, corePlayer.getNickname().map(Nickname::getRawValue).orElse(null)), QueryColumn.column(COLUMN_NICKNAME_TOKENS, corePlayer.getNicknameTokens()), QueryColumn.column(COLUMN_HORSE_CREATE_TOKENS, corePlayer.getHorseCreateTokens()), QueryColumn.column(COLUMN_ACTIVE_TAG_ID, corePlayer.getActiveTagId()), QueryColumn.column(COLUMN_XP, corePlayer.getXp()), QueryColumn.column(COLUMN_FINISHED_INDUCTION, corePlayer.isFinishedInduction()), QueryColumn.column(COLUMN_DONATOR, corePlayer.isDonator()), QueryColumn.column(COLUMN_DONATOR_LEVEL, corePlayer.getDonatorLevel()), QueryColumn.column(COLUMN_JOB_ID, corePlayer.getJobId()), QueryColumn.column(COLUMN_UNIVERSITY_HOUSE_ID, corePlayer.getUniversityHouseId()), QueryColumn.column(COLUMN_UNIVERSITY_HOUSE_JOIN_DATE, corePlayer.getUniversityHouseJoinDate()), QueryColumn.column(COLUMN_CLUB_PLUS, corePlayer.isClubPlus()), QueryColumn.column(COLUMN_DISCORD_ACCOUNT_ID, corePlayer.getDiscordAccountId()), QueryColumn.column(COLUMN_FACTION_ID, corePlayer.getFactionId()), QueryColumn.column(COLUMN_FACTION_XP, corePlayer.getFactionXp()), QueryColumn.column(COLUMN_HONOR_SCORE, corePlayer.getHonorScore()), QueryColumn.column(COLUMN_CUSTOM_JOIN_MESSAGE, corePlayer.getCustomJoinMessage()), QueryColumn.column(COLUMN_CUSTOM_LEAVE_MESSAGE, corePlayer.getCustomLeaveMessage()), QueryColumn.column(COLUMN_LAST_DAILY_JOIN_REWARD_TIME, corePlayer.getLastDailyJoinRewardTime()), QueryColumn.column(COLUMN_DAILY_JOIN_DAY_STREAK, corePlayer.getDailyJoinDayStreak()), QueryColumn.column(COLUMN_GLOW_ACCESS, corePlayer.isGlowAccess())).executeGetGeneratedKey(corePlayer::setId);
    }

    @Override
    public List<CorePlayer> retrieveAll() {
        return Query.selectAllFrom("PLAYER").getList(this::getFromResultRow);
    }

    private CorePlayer getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        UUID accountUuid = row.getUuid(COLUMN_ACCOUNT_UUID);
        String ign = row.getString(COLUMN_IGN);
        Date firstSeen = new Date(row.getLong(COLUMN_FIRST_SEEN));
        Date lastSeen = new Date(row.getLong(COLUMN_LAST_SEEN));
        String ipAddress = row.getString(COLUMN_IP_ADDRESS);
        long playtime = row.getLong(COLUMN_PLAYTIME);
        String nicknameText = row.getNullableString(COLUMN_NICKNAME);
        Nickname nickname = Nickname.createNickname(nicknameText);
        int nicknameTokens = row.getInt(COLUMN_NICKNAME_TOKENS);
        int horseCreateTokens = row.getInt(COLUMN_HORSE_CREATE_TOKENS);
        Integer activeTagId = row.getNullableInt(COLUMN_ACTIVE_TAG_ID);
        int xp = row.getInt(COLUMN_XP);
        boolean finishedInduction = row.getBoolean(COLUMN_FINISHED_INDUCTION);
        boolean donator = row.getBoolean(COLUMN_DONATOR);
        DonatorLevel donatorLevel = row.getNullableEnum(COLUMN_DONATOR_LEVEL, DonatorLevel.class);
        Integer jobId = row.getNullableInt(COLUMN_JOB_ID);
        Integer universityHouseId = row.getNullableInt(COLUMN_UNIVERSITY_HOUSE_ID);
        java.sql.Date universityHouseJoinDate = row.getNullableDate(COLUMN_UNIVERSITY_HOUSE_JOIN_DATE);
        boolean clubPlus = row.getBoolean(COLUMN_CLUB_PLUS);
        Long discordAccountId = row.getNullableLong(COLUMN_DISCORD_ACCOUNT_ID);
        String discordNicknameSeparator = row.getNullableString(COLUMN_DISCORD_NICKNAME_SEPARATOR);
        java.sql.Date agreedToRulesTime = row.getNullableDate(COLUMN_AGREED_TO_RULES_TIME);
        Integer factionId = row.getNullableInt(COLUMN_FACTION_ID);
        int factionXp = row.getInt(COLUMN_FACTION_XP);
        RideStyle rideStylePreference = row.getNullableEnum(COLUMN_RIDE_STYLE_PREFERENCE, RideStyle.class);
        int honorScore = row.getInt(COLUMN_HONOR_SCORE);
        String customJoinMessage = row.getNullableString(COLUMN_CUSTOM_JOIN_MESSAGE);
        String customLeaveMessage = row.getNullableString(COLUMN_CUSTOM_LEAVE_MESSAGE);
        java.sql.Date lastDailyJoinRewardTime = row.getNullableDate(COLUMN_LAST_DAILY_JOIN_REWARD_TIME);
        int dailyJoinDayStreak = row.getInt(COLUMN_DAILY_JOIN_DAY_STREAK);
        boolean glowAccess = row.getBoolean(COLUMN_GLOW_ACCESS);
        return new CorePlayer(id, accountUuid, ign, firstSeen, lastSeen, ipAddress, playtime, nickname, nicknameTokens, horseCreateTokens, activeTagId, xp, finishedInduction, donator, donatorLevel, jobId, universityHouseId, universityHouseJoinDate, clubPlus, discordAccountId, discordNicknameSeparator, agreedToRulesTime, factionId, factionXp, rideStylePreference, honorScore, customJoinMessage, customLeaveMessage, lastDailyJoinRewardTime, dailyJoinDayStreak, glowAccess);
    }

    @Override
    public void update(CorePlayer player) {
        Query.update("PLAYER").set(QueryColumn.column(COLUMN_IGN, player.getIgn()), QueryColumn.column(COLUMN_LAST_SEEN, player.getLastSeen()), QueryColumn.column(COLUMN_IP_ADDRESS, player.getIpAddress()), QueryColumn.column(COLUMN_PLAYTIME, player.getPlaytime()), QueryColumn.column(COLUMN_NICKNAME, player.getNickname().map(Nickname::getRawValue).orElse(null)), QueryColumn.column(COLUMN_NICKNAME_TOKENS, player.getNicknameTokens()), QueryColumn.column(COLUMN_HORSE_CREATE_TOKENS, player.getHorseCreateTokens()), QueryColumn.column(COLUMN_ACTIVE_TAG_ID, player.getActiveTagId()), QueryColumn.column(COLUMN_XP, player.getXp()), QueryColumn.column(COLUMN_FINISHED_INDUCTION, player.isFinishedInduction()), QueryColumn.column(COLUMN_DONATOR, player.isDonator()), QueryColumn.column(COLUMN_DONATOR_LEVEL, player.getDonatorLevel()), QueryColumn.column(COLUMN_JOB_ID, player.getJobId()), QueryColumn.column(COLUMN_UNIVERSITY_HOUSE_ID, player.getUniversityHouseId()), QueryColumn.column(COLUMN_UNIVERSITY_HOUSE_JOIN_DATE, player.getUniversityHouseJoinDate()), QueryColumn.column(COLUMN_CLUB_PLUS, player.isClubPlus()), QueryColumn.column(COLUMN_DISCORD_ACCOUNT_ID, player.getDiscordAccountId()), QueryColumn.column(COLUMN_DISCORD_NICKNAME_SEPARATOR, player.getDiscordNicknameSeparator()), QueryColumn.column(COLUMN_AGREED_TO_RULES_TIME, player.getAgreedToRulesTime()), QueryColumn.column(COLUMN_FACTION_ID, player.getFactionId()), QueryColumn.column(COLUMN_FACTION_XP, player.getFactionXp()), QueryColumn.column(COLUMN_RIDE_STYLE_PREFERENCE, player.getRideStylePreference()), QueryColumn.column(COLUMN_HONOR_SCORE, player.getHonorScore()), QueryColumn.column(COLUMN_CUSTOM_JOIN_MESSAGE, player.getCustomJoinMessage()), QueryColumn.column(COLUMN_CUSTOM_LEAVE_MESSAGE, player.getCustomLeaveMessage()), QueryColumn.column(COLUMN_LAST_DAILY_JOIN_REWARD_TIME, player.getLastDailyJoinRewardTime()), QueryColumn.column(COLUMN_DAILY_JOIN_DAY_STREAK, player.getDailyJoinDayStreak()), QueryColumn.column(COLUMN_GLOW_ACCESS, player.isGlowAccess())).where(QueryColumn.column(COLUMN_ID, player.getId())).execute();
    }
}

