/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.economy.DualAccountEconomyResponse;
import com.equestricraft.core.economy.Economy;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.economy.SingleAccountEconomyResponse;
import com.equestricraft.core.economy.account.BankAccountHoldingEntity;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;

public class PlayerEconomyAccessor
extends AbstractPlayerAccessor {
    @Service
    private static Economy economy;

    public PlayerEconomyAccessor(CorePlayer player) {
        super(player);
    }

    public double getBalance() {
        return economy.getBalance(this.player);
    }

    public String getBalanceFormatted() {
        double balance = this.getBalance();
        return EconomyUtilities.formatCurrency(balance);
    }

    public boolean hasBalance(double amount) {
        return economy.hasBalance(this.player, amount);
    }

    public SingleAccountEconomyResponse deposit(double amount, String reason, String sourceDescription) {
        return economy.deposit(this.player, amount, reason, sourceDescription);
    }

    public SingleAccountEconomyResponse withdraw(double amount, String reason, String sourceDescription) throws EconomyException {
        return economy.withdraw(this.player, amount, reason, sourceDescription);
    }

    public DualAccountEconomyResponse sendTo(ECPlayer target, double amount, String reason) throws EconomyException {
        return economy.transfer((ECPlayer)this.player, target, amount, reason);
    }

    public DualAccountEconomyResponse sendTo(BankAccountHoldingEntity target, double amount, String reason) throws EconomyException {
        return economy.transfer((ECPlayer)this.player, target, amount, reason);
    }
}

