/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.ban.BanInfo;
import com.equestricraft.core.ban.BanSession;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.economy.EconomySettings;
import com.equestricraft.core.economy.account.BankAccountSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.JoinBlockedException;
import com.equestricraft.core.player.LoginInfo;
import com.equestricraft.core.player.NewPlayerSettings;
import com.equestricraft.core.player.PlayerJoinLeaveService;
import com.equestricraft.core.player.PlayerJoinResponse;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.core.player.dailyjoin.PlayerDailyJoinRewardSession;
import com.equestricraft.core.player.settings.PlayerSettingsSession;
import com.equestricraft.core.utilities.BroadcastMessageHelper;
import com.equestricraft.discord.DiscordNewPlayerAlerter;
import com.equestricraft.discord.DiscordPlayerNicknameUpdater;
import com.equestricraft.logging.Log;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;

@TransactionManagement
public class PlayerJoinLeaveServiceImpl
implements PlayerJoinLeaveService {
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerService playerService;
    @Service
    private BankAccountSession bankAccountSession;
    @Service
    private PlayerSettingsSession playerSettingsSession;
    @Service
    private BanSession banSession;
    @Service
    private PlayerDailyJoinRewardSession playerDailyJoinRewardSession;
    private final DiscordNewPlayerAlerter discordNewPlayerAlerter = new DiscordNewPlayerAlerter();
    private final DiscordPlayerNicknameUpdater discordPlayerNicknameUpdater = new DiscordPlayerNicknameUpdater();
    private static final Log log = Log.getLogger(PlayerJoinLeaveServiceImpl.class.getName());

    @Override
    public PlayerJoinResponse processPlayerJoin(LoginInfo loginInfo) throws JoinBlockedException {
        Optional<CorePlayer> playerOptional = this.playerRepository.findPlayerByAccountUuid(loginInfo.accountUuid());
        this.ensureNotBanned(loginInfo.ipAddress());
        if (playerOptional.isPresent()) {
            CorePlayer corePlayer = playerOptional.get();
            this.ensureNotBanned(corePlayer);
            this.updatePlayerDetails(loginInfo, corePlayer);
            this.discordPlayerNicknameUpdater.syncPlayersNickname(playerOptional.get().getId());
            this.broadcastCustomJoinMessage(corePlayer);
            Optional<String> response = this.playerDailyJoinRewardSession.processPlayerJoin(playerOptional.get());
            response.ifPresent(s -> ((CorePlayer)playerOptional.get()).sendMessage((String)s));
            return PlayerJoinResponse.existingPlayer(playerOptional.get());
        }
        ECPlayer newPlayer = this.setUpNewPlayer(loginInfo);
        this.updatePlayerDetails(loginInfo, newPlayer.getCorePlayer());
        this.discordNewPlayerAlerter.sendNewPlayerAlert(newPlayer.getId());
        return PlayerJoinResponse.newPlayer(newPlayer);
    }

    private void ensureNotBanned(String ipAddress) throws JoinBlockedException {
        Optional<BanInfo> ban = this.banSession.findIpAddressesCurrentBan(ipAddress);
        if (ban.isPresent()) {
            throw new JoinBlockedException(this.buildBanMessage(ban.get()));
        }
    }

    private void ensureNotBanned(ECPlayer player) throws JoinBlockedException {
        Optional<BanInfo> ban = this.banSession.findPlayersCurrentBan(player);
        if (ban.isPresent()) {
            throw new JoinBlockedException(this.buildBanMessage(ban.get()));
        }
    }

    private String buildBanMessage(BanInfo banInfo) {
        return String.format("You are banned\n\nDuration: %s\n\nReason: %s\n", this.durationString(banInfo), banInfo.reason());
    }

    private String durationString(BanInfo banInfo) {
        if (banInfo.permanent()) {
            return "Permanent";
        }
        return banInfo.daysLeft() + " days";
    }

    private void updatePlayerDetails(LoginInfo loginInfo, CorePlayer player) {
        player.setIgn(loginInfo.ign());
        player.setIpAddress(loginInfo.ipAddress());
        player.setLastSeen(new Date());
        player.save();
    }

    private void broadcastCustomJoinMessage(CorePlayer player) {
        if (player.getCustomJoinMessage() != null && !player.getCustomJoinMessage().isBlank()) {
            TaskScheduler.executeAsyncTask(() -> BroadcastMessageHelper.broadcastMessage(player.getCustomJoinMessage()));
        }
    }

    private ECPlayer setUpNewPlayer(LoginInfo loginInfo) {
        ECPlayer player = this.registerNewPlayer(loginInfo);
        this.initialisePlayersEconomy(player);
        this.playerSettingsSession.initialiseSettingsForPlayer(player);
        return player;
    }

    private ECPlayer registerNewPlayer(LoginInfo loginInfo) {
        CorePlayer player = this.buildNewPlayerFromLoginInfo(loginInfo);
        player = this.playerRepository.add(player);
        log.info("New player with account UUID {} and IGN {} has joined. Internal ID number is {}", player.getAccountUuid(), player.getIgn(), player.getId());
        return player;
    }

    private CorePlayer buildNewPlayerFromLoginInfo(LoginInfo loginInfo) {
        int nicknameTokens = NewPlayerSettings.getNicknameTokens();
        int horseCreateTokens = NewPlayerSettings.getHorseCreateTokens();
        return new CorePlayer(0, loginInfo.accountUuid(), loginInfo.ign(), loginInfo.connectionTime(), loginInfo.connectionTime(), loginInfo.ipAddress(), 0L, null, nicknameTokens, horseCreateTokens, null, 0, false, false, null, null, null, null, false, null, null, null, null, 0, null, 0, null, null, null, 0, false);
    }

    private void initialisePlayersEconomy(ECPlayer player) {
        try {
            this.bankAccountSession.createMainAccount(player);
            Double startingBalance = EconomySettings.getStartingBalance();
            player.getEconomy().deposit(startingBalance, I18n.getLabel("economy.transaction.starting-balance"), "New Player");
        }
        catch (EconomyException ex) {
            log.error("Tried to initialise an account for a player who already had", (Object)player.getIgn());
        }
    }

    @Override
    public void processPlayerLeave(UUID accountUuid) {
        CorePlayer player = this.playerService.retrievePlayerByAccountUuid(accountUuid);
        Duration newPlaytime = this.calculateNewPlaytime(player);
        player.setPlaytime(newPlaytime.toMillis());
        player.setLastSeen(new Date());
        player.save();
        this.broadcastCustomLeaveMessage(player);
        player.clearECPlayerData();
    }

    private Duration calculateNewPlaytime(CorePlayer player) {
        long playtimeOnJoin = player.getPlaytime();
        long sessionDuration = DateUtils.millisSince(player.getLastSeen());
        return Duration.ofMillis(playtimeOnJoin + sessionDuration);
    }

    private void broadcastCustomLeaveMessage(CorePlayer player) {
        if (player.getCustomLeaveMessage() != null && !player.getCustomLeaveMessage().isBlank()) {
            TaskScheduler.executeAsyncTask(() -> BroadcastMessageHelper.broadcastMessage(player.getCustomLeaveMessage()));
        }
    }
}

