/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositoryUpdatePolicy;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerDatabase;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public class PlayerRepository
extends Repository<CorePlayer, Integer> {
    @Service
    private PlayerDatabase playerDatabase;

    @Override
    protected RepositoryDatasource<CorePlayer, Integer> getDatasource() {
        return this.playerDatabase;
    }

    @Override
    protected RepositoryUpdatePolicy updatePolicy() {
        return RepositoryUpdatePolicy.UPDATE_NOT_ALLOWED;
    }

    @Override
    protected Function<CorePlayer, Object> getIndexFunction() {
        return CorePlayer::getAccountUuid;
    }

    public Optional<CorePlayer> findPlayerByAccountUuid(UUID accountUuid) {
        return this.findByIndexKeyIfExists(accountUuid);
    }

    public Optional<CorePlayer> findPlayerByIgn(String ign) {
        return this.findSingleByPredicates((T p) -> p.getIgn().equalsIgnoreCase(ign));
    }

    public List<CorePlayer> findPlayersInJob(int jobId) {
        return this.findListByPredicates((T p) -> p.getJobId() != null && p.getJobId() == jobId);
    }

    public List<CorePlayer> findPlayersInUniversityHouse(int universityHouseId) {
        return this.findListByPredicates((T p) -> p.getUniversityHouseId() != null && p.getUniversityHouseId() == universityHouseId);
    }

    public List<CorePlayer> findPlayersWithIpAddress(String ipAddress) {
        return this.findListByPredicates((T p) -> p.getIpAddress().equals(ipAddress));
    }
}

