/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import com.equestricraft.api.common.APIPlayerDto;
import com.equestricraft.common.util.ObjectUtils;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.core.player.PlayerSimple;
import com.equestricraft.core.player.nickname.Nickname;
import java.util.List;

public class PlayerTransformer {
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    public APIPlayerDto toApiDto(CorePlayer player) {
        if (player == null) {
            return null;
        }
        return new APIPlayerDtoImpl(player);
    }

    public CorePlayer fromDto(APIPlayerDto playerDto) {
        return ObjectUtils.castMap(playerDto, APIPlayerDtoImpl.class, APIPlayerDtoImpl::getCorePlayer);
    }

    public List<PlayerSimple> toSimpleList(List<CorePlayer> players) {
        return players.stream().map(this::toSimple).toList();
    }

    public PlayerSimple toSimple(CorePlayer player) {
        return new PlayerSimple(player.getId(), player.getIgn(), player.getNickname().map(Nickname::getColorStripped).orElse(null), player.getAccountUuid(), this.onlinePlayerCache.isPlayerOnline(player.getId()));
    }
}

