/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;

public class SpeedLimitCache {
    private static final SpeedLimitCache instance = new SpeedLimitCache();
    private final Map<Integer, Float> speedLimitMap = new HashMap<Integer, Float>();
    private final StampedLock lock = new StampedLock();

    public static SpeedLimitCache getInstance() {
        return instance;
    }

    private SpeedLimitCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Float> getCurrentSpeedLimit(Integer id) {
        long stamp = this.lock.readLock();
        try {
            Float speed = this.speedLimitMap.get(id);
            Optional<Float> optional = Optional.ofNullable(speed);
            return optional;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentSpeed(Integer id, Float speed) {
        long stamp = this.lock.writeLock();
        try {
            this.speedLimitMap.put(id, speed);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

