/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.achievement;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.achievement.PlayerAchievementProvider;
import com.equestricraft.core.repeatingtask.RepeatingTask;
import java.time.Duration;
import java.util.List;

public class AchievementUpdater
extends RepeatingTask {
    @Service
    private ServiceInstance<PlayerAchievementProvider> playerAchievementProviders;
    @Service
    private PlayerRepository playerRepository;

    @Override
    public String name() {
        return "achievement-updater";
    }

    @Override
    public void execute() {
        for (CorePlayer player : this.playerRepository) {
            List<PlayerAchievementProvider> newlyCompleted = this.playerAchievementProviders.stream().filter(a -> a.getPercentageProgression(player) >= 100.0 && !player.getAchievements().hasAchievement(a.getIdentifier())).toList();
            for (PlayerAchievementProvider achievement : newlyCompleted) {
                player.getAchievements().completeAchievement(achievement);
            }
        }
    }

    @Override
    public Duration delay() {
        return Duration.ofMinutes(1L);
    }

    @Override
    public Duration period() {
        return Duration.ofMinutes(1L);
    }
}

