/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.achievement;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.core.interpolation.PlayerStringInterpolator;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.achievement.PlayerAchievement;
import com.equestricraft.core.player.achievement.PlayerAchievementProvider;
import com.equestricraft.core.player.achievement.PlayerAchievementSession;
import com.equestricraft.core.player.achievement.PlayerAchievementsProvider;
import com.equestricraft.core.player.achievement.log.PlayerAchievementLog;
import com.equestricraft.core.player.achievement.log.PlayerAchievementLogSession;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class PlayerAchievementSessionImpl
implements PlayerAchievementSession {
    @Service
    private ServiceInstance<PlayerAchievementProvider> playerAchievementProviders;
    @Service
    private ServiceInstance<PlayerAchievementsProvider> playerAchievementsProviders;
    @Service
    private PlayerAchievementLogSession playerAchievementLogSession;

    @Override
    public List<PlayerAchievement> getPlayersAchievements(ECPlayer player) {
        Stream singleAchievements = this.playerAchievementProviders.stream();
        Stream dynamicAchievements = this.playerAchievementsProviders.stream().flatMap(PlayerAchievementsProvider::getAchievements);
        PlayerStringInterpolator interpolator = new PlayerStringInterpolator(player);
        return Stream.concat(singleAchievements, dynamicAchievements).flatMap(a -> {
            double percentage = a.getPercentageProgression(player);
            if (percentage >= a.getMinimumShowPercentage()) {
                String name = interpolator.execute(a.getName());
                String description = interpolator.execute(a.getDescription());
                return Stream.of(new PlayerAchievement(name, description, a.getXpReward(), percentage));
            }
            return Stream.empty();
        }).sorted(this.buildComparison()).toList();
    }

    private Comparator<PlayerAchievement> buildComparison() {
        return Comparator.comparing(PlayerAchievement::isComplete).thenComparing(Comparator.comparingDouble(PlayerAchievement::getPercentageCompletion).reversed());
    }

    @Override
    public boolean hasPlayerCompletedAchievement(ECPlayer player, String identifier) {
        List<PlayerAchievementLog> logs = this.playerAchievementLogSession.getAllPlayersLogs(player);
        return logs.stream().anyMatch(l -> l.getAchievementIdentifier().equals(identifier));
    }
}

