/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.achievement;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.achievement.PlayerAchievementProvider;
import com.equestricraft.core.player.achievement.PlayerAchievementUpdateSession;
import com.equestricraft.core.player.achievement.log.PlayerAchievementLogSession;

public class PlayerAchievementUpdateSessionImpl
implements PlayerAchievementUpdateSession {
    @Service
    private PlayerAchievementLogSession playerAchievementLogSession;

    @Override
    public void completeAchievementForPlayer(ECPlayer player, PlayerAchievementProvider achievement) {
        this.playerAchievementLogSession.logAchievement(player, achievement.getIdentifier());
        if (player.isOnline()) {
            player.sendTitle(achievement.getName(), achievement.getDescription());
        } else {
            player.notify(I18n.getLabel("player.achievement-unlocked", achievement.getName(), achievement.getDescription()));
        }
        player.getProgression().giveXp(achievement.getXpReward());
    }
}

