/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.achievement.log;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.achievement.log.PlayerAchievementLog;
import com.equestricraft.core.player.achievement.log.PlayerAchievementLogKey;
import java.util.List;

public class PlayerAchievementLogDatabase
implements RepositoryDatasource<PlayerAchievementLog, PlayerAchievementLogKey> {
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_ACHIEVEMENT_IDENTIFIER = "ACHIEVEMENT_IDENTIFIER";
    private static final String COLUMN_COMPLETE_TIME = "COMPLETE_TIME";

    @Override
    public void create(PlayerAchievementLog playerAchievementLog) {
        Query.insertInto("PLAYER_ACHIEVEMENT_LOG").columns(QueryColumn.column(COLUMN_PLAYER_ID, playerAchievementLog.getPlayerId()), QueryColumn.column(COLUMN_ACHIEVEMENT_IDENTIFIER, playerAchievementLog.getAchievementIdentifier()), QueryColumn.column(COLUMN_COMPLETE_TIME, playerAchievementLog.getCompleteTime())).execute();
    }

    @Override
    public List<PlayerAchievementLog> retrieveAll() {
        return Query.selectAllFrom("PLAYER_ACHIEVEMENT_LOG").getList(this::getFromResultRow);
    }

    private PlayerAchievementLog getFromResultRow(ResultRow row) {
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        String achievementIdentifier = row.getString(COLUMN_ACHIEVEMENT_IDENTIFIER);
        long completeTime = row.getLong(COLUMN_COMPLETE_TIME);
        return new PlayerAchievementLog(playerId, achievementIdentifier, completeTime);
    }
}

