/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.achievement.log;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.achievement.log.PlayerAchievementLog;
import com.equestricraft.core.player.achievement.log.PlayerAchievementLogDatabase;
import com.equestricraft.core.player.achievement.log.PlayerAchievementLogKey;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class PlayerAchievementLogRepository
extends Repository<PlayerAchievementLog, PlayerAchievementLogKey> {
    @Service
    private PlayerAchievementLogDatabase playerAchievementLogDatabase;

    @Override
    protected RepositoryDatasource<PlayerAchievementLog, PlayerAchievementLogKey> getDatasource() {
        return this.playerAchievementLogDatabase;
    }

    @Override
    protected Function<PlayerAchievementLog, Object> getIndexFunction() {
        return PlayerAchievementLog::getPlayerId;
    }

    public Optional<PlayerAchievementLog> findByPlayerAndAchievement(int playerId, String achievementIdentifier) {
        return this.findByKeyIfExists(new PlayerAchievementLogKey(playerId, achievementIdentifier));
    }

    public List<PlayerAchievementLog> findByPlayer(int playerId) {
        return this.findListByIndexKey(playerId);
    }
}

