/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.afk;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.OnlinePlayerCache;
import com.equestricraft.core.player.afk.AfkSettings;
import java.time.Duration;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;

public class AfkTimer {
    private static final AfkTimer instance = new AfkTimer();
    private final Timer timer = new Timer(ThreadUtils.threadName("afk-timer"));
    private boolean isRunning = false;
    private final OnlinePlayerCache onlinePlayerCache = OnlinePlayerCache.getInstance();

    public static AfkTimer getInstance() {
        return instance;
    }

    private AfkTimer() {
    }

    public synchronized void start() {
        if (this.isRunning) {
            throw new IllegalStateException("AFK timer is already running");
        }
        long period = Duration.ofSeconds(10L).toMillis();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                AfkTimer.this.performCheck();
            }
        }, period, period);
        this.isRunning = true;
    }

    private void performCheck() {
        int afkInactivitySeconds = AfkSettings.getTimerSeconds();
        List<ECPlayer> newAfkPlayers = this.onlinePlayerCache.getAllPlayers().stream().filter(Predicate.not(p -> p.getAfk().isAFk())).filter(p -> this.hasPlayerBeenInactiveForAtLeast((ECPlayer)p, afkInactivitySeconds)).toList();
        for (ECPlayer player : newAfkPlayers) {
            player.sendMessage(I18n.getLabel("afk.you-are-now-afk"));
            player.getAfk().setAfk();
        }
    }

    private boolean hasPlayerBeenInactiveForAtLeast(ECPlayer player, int afkInactivitySeconds) {
        Duration durationSinceLastActivity = player.getAfk().getLastActivity();
        long seconds = durationSinceLastActivity.toSeconds();
        return seconds >= (long)afkInactivitySeconds;
    }

    public synchronized void stop() {
        if (!this.isRunning) {
            return;
        }
        this.timer.cancel();
        this.isRunning = false;
    }
}

