/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.afk;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;

public class PlayerAfkAccessor
extends AbstractPlayerAccessor {
    private Long afkSince = null;
    private long lastActivity = System.currentTimeMillis();

    public PlayerAfkAccessor(CorePlayer player) {
        super(player);
    }

    public boolean isAFk() {
        return this.afkSince != null;
    }

    public void setAfk() {
        this.afkSince = System.currentTimeMillis();
    }

    public Optional<Date> getAfkSince() {
        if (this.afkSince != null) {
            return Optional.of(new Date(this.afkSince));
        }
        return Optional.empty();
    }

    public void clearAfk() {
        this.afkSince = null;
        this.lastActivity = System.currentTimeMillis();
    }

    public Duration getLastActivity() {
        return DateUtils.durationSince(this.lastActivity);
    }
}

