/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.attribute;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.attribute.PlayerAttributeValueKey;
import com.equestricraft.core.player.attribute.PlayerAttributeValueRepository;
import java.util.Objects;

public class PlayerAttributeValue
implements RepositoryEntity<PlayerAttributeValueKey> {
    private final PlayerAttributeValueKey key;
    private String value;

    public PlayerAttributeValue(int playerId, int attributeId, String value) {
        this.key = new PlayerAttributeValueKey(playerId, attributeId);
        this.value = value;
    }

    @Override
    public PlayerAttributeValueKey getKey() {
        return this.key;
    }

    public int getPlayerId() {
        return this.getKey().playerId();
    }

    public int getAttributeId() {
        return this.getKey().attributeId();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void save() {
        Services.getService(PlayerAttributeValueRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerAttributeValue that = (PlayerAttributeValue)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

