/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.attribute;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.attribute.PlayerAttributeValue;
import com.equestricraft.core.player.attribute.PlayerAttributeValueKey;
import java.util.List;

public class PlayerAttributeValueDatabase
implements RepositoryDatasource<PlayerAttributeValue, PlayerAttributeValueKey> {
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_ATTRIBUTE_ID = "ATTRIBUTE_ID";
    private static final String COLUMN_VALUE = "VALUE";

    @Override
    public void create(PlayerAttributeValue playerAttributeValue) {
        Query.insertInto("PLAYER_ATTRIBUTE_VALUE").columns(QueryColumn.column(COLUMN_PLAYER_ID, playerAttributeValue.getPlayerId()), QueryColumn.column(COLUMN_ATTRIBUTE_ID, playerAttributeValue.getAttributeId()), QueryColumn.column(COLUMN_VALUE, playerAttributeValue.getValue())).execute();
    }

    @Override
    public List<PlayerAttributeValue> retrieveAll() {
        return Query.selectAllFrom("PLAYER_ATTRIBUTE_VALUE").getList(this::getFromResultRow);
    }

    private PlayerAttributeValue getFromResultRow(ResultRow row) {
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        int attributeId = row.getInt(COLUMN_ATTRIBUTE_ID);
        String value = row.getNullableString(COLUMN_VALUE);
        return new PlayerAttributeValue(playerId, attributeId, value);
    }

    @Override
    public void update(PlayerAttributeValue playerAttributeValue) {
        Query.update("PLAYER_ATTRIBUTE_VALUE").set(QueryColumn.column(COLUMN_VALUE, playerAttributeValue.getValue())).where(QueryColumn.column(COLUMN_PLAYER_ID, playerAttributeValue.getPlayerId()), QueryColumn.column(COLUMN_ATTRIBUTE_ID, playerAttributeValue.getAttributeId())).execute();
    }
}

