/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.attribute;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.attribute.player.PlayerAttribute;
import com.equestricraft.core.attribute.player.PlayerAttributeRepository;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.attribute.PlayerAttributeValue;
import com.equestricraft.core.player.attribute.PlayerAttributeValueKey;
import com.equestricraft.core.player.attribute.PlayerAttributeValueRepository;
import com.equestricraft.core.player.attribute.PlayerAttributeValueSession;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyScriptResponse;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.util.Optional;

public class PlayerAttributeValueSessionImpl
implements PlayerAttributeValueSession {
    @Service
    private PlayerAttributeValueRepository playerAttributeValueRepository;
    @Service
    private PlayerAttributeRepository playerAttributeRepository;
    private static final String GROOVY_VARIABLE_VALUE = "value";
    private static final Log log = Log.getLogger(PlayerAttributeValueSessionImpl.class.getName());

    @Override
    public void setAttributeValueForPlayer(CorePlayer player, int attributeId, Object value) {
        String strValue = value != null ? value.toString() : null;
        Optional playerAttributeValueOptional = this.playerAttributeValueRepository.findByKeyIfExists(this.key(player, attributeId));
        if (playerAttributeValueOptional.isPresent()) {
            PlayerAttributeValue playerAttributeValue = (PlayerAttributeValue)playerAttributeValueOptional.get();
            playerAttributeValue.setValue(strValue);
            playerAttributeValue.save();
        } else {
            PlayerAttributeValue newValue = new PlayerAttributeValue(player.getId(), attributeId, strValue);
            this.playerAttributeValueRepository.add(newValue);
        }
    }

    @Override
    public void setAttributeValueForPlayer(CorePlayer player, String attributeIdentifier, Object value) {
        PlayerAttribute attribute = (PlayerAttribute)this.playerAttributeRepository.findByIdentifier(attributeIdentifier);
        this.setAttributeValueForPlayer(player, attribute.getId(), value);
    }

    @Override
    public Optional<String> getAttributeValueForPlayer(CorePlayer player, int attributeId) {
        return this.playerAttributeValueRepository.findByKeyIfExists(this.key(player, attributeId)).map(PlayerAttributeValue::getValue);
    }

    @Override
    public Optional<String> getAttributeValueForPlayer(CorePlayer player, String attributeIdentifier) {
        PlayerAttribute attribute = (PlayerAttribute)this.playerAttributeRepository.findByIdentifier(attributeIdentifier);
        return this.getAttributeValueForPlayer(player, attribute.getId());
    }

    private PlayerAttributeValueKey key(CorePlayer player, int attributeId) {
        return new PlayerAttributeValueKey(player.getId(), attributeId);
    }

    @Override
    public boolean isAttributeTrueForPlayer(CorePlayer player, int attributeId) {
        PlayerAttribute playerAttribute = (PlayerAttribute)this.playerAttributeRepository.findByKey(attributeId);
        return this.isAttributeTrueForPlayer(player, playerAttribute);
    }

    @Override
    public boolean isAttributeTrueForPlayer(CorePlayer player, String attributeIdentifier) {
        PlayerAttribute playerAttribute = (PlayerAttribute)this.playerAttributeRepository.findByIdentifier(attributeIdentifier);
        return this.isAttributeTrueForPlayer(player, playerAttribute);
    }

    private boolean isAttributeTrueForPlayer(CorePlayer player, PlayerAttribute attribute) {
        String value = this.getAttributeValueForPlayer(player, attribute.getId()).orElse(null);
        return this.executeTrueConditionScript(attribute, player, value);
    }

    private boolean executeTrueConditionScript(PlayerAttribute playerAttribute, CorePlayer player, String value) {
        try {
            GroovyScriptResponse response = ((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(playerAttribute.getTrueConditionScript()).withPlayer(new APIPlayerDtoImpl(player))).withVariable(GROOVY_VARIABLE_VALUE, value)).execute();
            Boolean result = (Boolean)response.result();
            return result != null && result != false;
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing script for attribute %s", playerAttribute.getName()), ex);
            return false;
        }
    }

    @Override
    public boolean isAttributeFalseForPlayer(CorePlayer player, int attributeId) {
        return !this.isAttributeTrueForPlayer(player, attributeId);
    }

    @Override
    public boolean isAttributeFalseForPlayer(CorePlayer player, String attributeIdentifier) {
        return !this.isAttributeTrueForPlayer(player, attributeIdentifier);
    }

    @Override
    public String getAttributeDisplayValueForPlayer(CorePlayer player, int attributeId) {
        PlayerAttribute attribute = (PlayerAttribute)this.playerAttributeRepository.findByKey(attributeId);
        return this.getAttributeDisplayValueForPlayer(player, attribute);
    }

    @Override
    public String getAttributeDisplayValueForPlayer(CorePlayer player, String attributeIdentifier) {
        PlayerAttribute attribute = (PlayerAttribute)this.playerAttributeRepository.findByIdentifier(attributeIdentifier);
        return this.getAttributeDisplayValueForPlayer(player, attribute);
    }

    private String getAttributeDisplayValueForPlayer(CorePlayer player, PlayerAttribute attribute) {
        String value = this.getAttributeValueForPlayer(player, attribute.getId()).orElse(null);
        return this.executeDisplayScript(attribute, player, value);
    }

    private String executeDisplayScript(PlayerAttribute playerAttribute, CorePlayer player, String value) {
        try {
            GroovyScriptResponse response = ((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(playerAttribute.getDisplayScript()).withPlayer(new APIPlayerDtoImpl(player))).withVariable(GROOVY_VARIABLE_VALUE, value)).execute();
            if (response != null) {
                return response.toString();
            }
            return "";
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing script for attribute %s", playerAttribute.getName()), ex);
            return "";
        }
    }
}

