/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.bulletin;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.bulletin.BulletinPlayer;
import com.equestricraft.core.player.bulletin.BulletinPlayerKey;
import java.util.List;

public class BulletinPlayerDatabase
implements RepositoryDatasource<BulletinPlayer, BulletinPlayerKey> {
    private static final String COLUMN_BULLETIN_ID = "BULLETIN_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_SEEN_TIME = "SEEN_TIME";

    @Override
    public void create(BulletinPlayer bulletinPlayer) {
        Query.insertInto("BULLETIN_PLAYER").columns(QueryColumn.column(COLUMN_BULLETIN_ID, bulletinPlayer.getBulletinId()), QueryColumn.column(COLUMN_PLAYER_ID, bulletinPlayer.getPlayerId()), QueryColumn.column(COLUMN_SEEN_TIME, bulletinPlayer.getSeenTime())).execute();
    }

    @Override
    public List<BulletinPlayer> retrieveAll() {
        return Query.selectAllFrom("BULLETIN_PLAYER").getList(this::getFromResultRow);
    }

    private BulletinPlayer getFromResultRow(ResultRow row) {
        int bulletinId = row.getInt(COLUMN_BULLETIN_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long seenTime = row.getLong(COLUMN_SEEN_TIME);
        return new BulletinPlayer(bulletinId, playerId, seenTime);
    }
}

