/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.bulletin;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.bulletin.BulletinPlayer;
import com.equestricraft.core.player.bulletin.BulletinPlayerDatabase;
import com.equestricraft.core.player.bulletin.BulletinPlayerKey;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class BulletinPlayerRepository
extends Repository<BulletinPlayer, BulletinPlayerKey> {
    @Service
    private BulletinPlayerDatabase bulletinPlayerDatabase;

    @Override
    protected RepositoryDatasource<BulletinPlayer, BulletinPlayerKey> getDatasource() {
        return this.bulletinPlayerDatabase;
    }

    @Override
    protected Function<BulletinPlayer, Object> getIndexFunction() {
        return BulletinPlayer::getPlayerId;
    }

    public List<BulletinPlayer> findByPlayer(int playerId) {
        return this.findListByIndexKey(playerId);
    }

    public Optional<BulletinPlayer> findByBulletinAndPlayer(int bulletinId, int playerId) {
        return this.findByKeyIfExists(new BulletinPlayerKey(bulletinId, playerId));
    }
}

