/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.bulletin;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.bulletin.BulletinPlayer;
import com.equestricraft.core.player.bulletin.BulletinPlayerRepository;
import com.equestricraft.core.player.bulletin.BulletinPlayerSession;
import java.util.List;
import java.util.Optional;

public class BulletinPlayerSessionImpl
implements BulletinPlayerSession {
    @Service
    private BulletinPlayerRepository bulletinPlayerRepository;

    @Override
    public void markBulletinAsSeenByPlayer(int bulletinId, ECPlayer player) {
        Optional<BulletinPlayer> existing = this.bulletinPlayerRepository.findByBulletinAndPlayer(bulletinId, player.getId());
        if (existing.isPresent()) {
            return;
        }
        BulletinPlayer bulletinPlayer = new BulletinPlayer(bulletinId, player.getId(), System.currentTimeMillis());
        this.bulletinPlayerRepository.add(bulletinPlayer);
    }

    @Override
    public List<Integer> retrieveIdsOfBulletinsPlayerHasSeen(ECPlayer player) {
        List<BulletinPlayer> existing = this.bulletinPlayerRepository.findByPlayer(player.getId());
        return existing.stream().map(BulletinPlayer::getBulletinId).toList();
    }
}

