/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.character;

import com.equestricraft.api.common.APICharacterProfileDto;
import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIPlayerCharacterDto;
import com.equestricraft.api.common.APIPlayerCharacterFriendshipDto;
import com.equestricraft.core.character.APICharacterProfileDtoImpl;
import com.equestricraft.core.character.CharacterProfile;
import com.equestricraft.core.player.character.APIPlayerCharacterFriendshipDtoImpl;
import com.equestricraft.core.player.character.PlayerCharacterAccessor;
import java.time.Duration;
import java.util.Optional;

public class APIPlayerCharacterDtoImpl
implements APIPlayerCharacterDto {
    private final PlayerCharacterAccessor playerCharacterAccessor;
    private final CharacterProfile characterProfile;

    public APIPlayerCharacterDtoImpl(PlayerCharacterAccessor playerCharacterAccessor, CharacterProfile characterProfile) {
        this.playerCharacterAccessor = playerCharacterAccessor;
        this.characterProfile = characterProfile;
    }

    @Override
    public APICharacterProfileDto getCharacter() {
        return new APICharacterProfileDtoImpl(this.characterProfile);
    }

    @Override
    public APIDurationDto getDurationSinceFirstMet() {
        Optional<Duration> duration = this.playerCharacterAccessor.getDurationSinceFirstMet(this.characterProfile);
        return duration.map(APIDurationDto::new).orElse(null);
    }

    @Override
    public APIDurationDto getDurationSinceLastSeen() {
        Optional<Duration> duration = this.playerCharacterAccessor.getDurationSinceLastSeen(this.characterProfile.getId());
        return duration.map(APIDurationDto::new).orElse(null);
    }

    @Override
    public APIPlayerCharacterFriendshipDto getFriendship() {
        return new APIPlayerCharacterFriendshipDtoImpl(this.playerCharacterAccessor, this.characterProfile);
    }

    @Override
    public boolean isMet() {
        return this.playerCharacterAccessor.hasPlayerMetCharacter(this.characterProfile.getId());
    }

    @Override
    public void interact() {
        this.playerCharacterAccessor.processInteraction(this.characterProfile.getId());
    }
}

