/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.character;

import com.equestricraft.api.common.APIPlayerCharacterFriendshipDto;
import com.equestricraft.core.character.CharacterProfile;
import com.equestricraft.core.player.character.PlayerCharacterAccessor;

public class APIPlayerCharacterFriendshipDtoImpl
implements APIPlayerCharacterFriendshipDto {
    private final PlayerCharacterAccessor playerCharacterAccessor;
    private final CharacterProfile characterProfile;

    public APIPlayerCharacterFriendshipDtoImpl(PlayerCharacterAccessor playerCharacterAccessor, CharacterProfile characterProfile) {
        this.playerCharacterAccessor = playerCharacterAccessor;
        this.characterProfile = characterProfile;
    }

    @Override
    public double getValue() {
        return this.playerCharacterAccessor.getFriendshipPercentage(this.characterProfile.getId()).orElseThrow();
    }

    @Override
    public void setValue(double value) {
        this.playerCharacterAccessor.setFriendshipPercentage(this.characterProfile.getId(), value);
    }

    @Override
    public void increment(double amount) {
        this.playerCharacterAccessor.incrementFriendshipPercentage(this.characterProfile.getId(), amount);
    }

    @Override
    public void decrement(double amount) {
        this.playerCharacterAccessor.decrementFriendshipPercentage(this.characterProfile.getId(), amount);
    }

    public String toString() {
        return this.getValue() + "%";
    }
}

