/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.character;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.character.CharacterProfile;
import com.equestricraft.core.character.CharacterProfileRepository;
import com.equestricraft.core.compendium.CompendiumItem;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.character.CharacterCompendiumSession;
import com.equestricraft.core.player.character.CharacterPlayer;
import com.equestricraft.core.player.character.CharacterPlayerRepository;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class CharacterCompendiumSessionImpl
implements CharacterCompendiumSession {
    @Service
    private CharacterPlayerRepository characterPlayerRepository;
    @Service
    private CharacterProfileRepository characterProfileRepository;

    @Override
    public String getCompendiumIdentifier() {
        return "characters";
    }

    @Override
    public String getCompendiumLabel() {
        return I18n.getLabel("compendium-menu.characters.title");
    }

    @Override
    public List<CompendiumItem> getCompendiumItems(ECPlayer player) {
        List<CharacterPlayer> playersCharacters = this.characterPlayerRepository.findByPlayer(player.getId());
        return this.characterProfileRepository.streamAll().map(c -> this.buildItem((CharacterProfile)c, playersCharacters)).sorted(Comparator.comparing(CompendiumItem::getTitle)).toList();
    }

    private CompendiumItem buildItem(CharacterProfile character, List<CharacterPlayer> playersCharacters) {
        Date metDate = playersCharacters.stream().filter(c -> c.getCharacterId() == character.getId()).findFirst().map(CharacterPlayer::getFirstMet).map(Date::new).orElse(null);
        return new CompendiumItem(character.getName(), character.getDescription(), metDate);
    }
}

