/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.character;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.character.CharacterPlayerKey;
import com.equestricraft.core.player.character.CharacterPlayerRepository;
import java.util.Objects;

public class CharacterPlayer
implements RepositoryEntity<CharacterPlayerKey> {
    private final CharacterPlayerKey key;
    private final long firstMet;
    private long lastSeen;
    private double friendshipPercentage;

    public CharacterPlayer(int characterId, int playerId, long firstMet, long lastSeen, double friendshipPercentage) {
        this.friendshipPercentage = friendshipPercentage;
        this.key = new CharacterPlayerKey(characterId, playerId);
        this.firstMet = firstMet;
        this.lastSeen = lastSeen;
    }

    @Override
    public CharacterPlayerKey getKey() {
        return this.key;
    }

    public int getCharacterId() {
        return this.getKey().characterId();
    }

    public int getPlayerId() {
        return this.getKey().playerId();
    }

    public long getFirstMet() {
        return this.firstMet;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public double getFriendshipPercentage() {
        return this.friendshipPercentage;
    }

    public void setFriendshipPercentage(double friendshipPercentage) {
        this.friendshipPercentage = friendshipPercentage;
    }

    @Override
    public void save() {
        Services.getService(CharacterPlayerRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterPlayer that = (CharacterPlayer)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public String toString() {
        return this.key.characterId() + " - " + this.key.playerId();
    }
}

