/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.character;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.character.CharacterPlayer;
import com.equestricraft.core.player.character.CharacterPlayerKey;
import java.util.List;

public class CharacterPlayerDatabase
implements RepositoryDatasource<CharacterPlayer, CharacterPlayerKey> {
    private static final String COLUMN_CHARACTER_ID = "CHARACTER_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_FIRST_MET = "FIRST_MET";
    private static final String COLUMN_LAST_SEEN = "LAST_SEEN";
    private static final String COLUMN_FRIENDSHIP_PERCENTAGE = "FRIENDSHIP_PERCENTAGE";

    @Override
    public void create(CharacterPlayer characterPlayer) {
        Query.insertInto("CHARACTER_PLAYER").columns(QueryColumn.column(COLUMN_CHARACTER_ID, characterPlayer.getCharacterId()), QueryColumn.column(COLUMN_PLAYER_ID, characterPlayer.getPlayerId()), QueryColumn.column(COLUMN_FIRST_MET, characterPlayer.getFirstMet()), QueryColumn.column(COLUMN_LAST_SEEN, characterPlayer.getLastSeen()), QueryColumn.column(COLUMN_FRIENDSHIP_PERCENTAGE, characterPlayer.getFriendshipPercentage())).execute();
    }

    @Override
    public List<CharacterPlayer> retrieveAll() {
        return Query.selectAllFrom("CHARACTER_PLAYER").getList(this::getCharacterPlayerFromResultRow);
    }

    private CharacterPlayer getCharacterPlayerFromResultRow(ResultRow row) {
        int characterId = row.getInt(COLUMN_CHARACTER_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long firstMet = row.getLong(COLUMN_FIRST_MET);
        long lastSeen = row.getLong(COLUMN_LAST_SEEN);
        double friendshipPercentage = row.getDouble(COLUMN_FRIENDSHIP_PERCENTAGE);
        return new CharacterPlayer(characterId, playerId, firstMet, lastSeen, friendshipPercentage);
    }

    @Override
    public void update(CharacterPlayer characterPlayer) {
        Query.update("CHARACTER_PLAYER").set(QueryColumn.column(COLUMN_LAST_SEEN, characterPlayer.getLastSeen())).where(QueryColumn.column(COLUMN_CHARACTER_ID, characterPlayer.getCharacterId()), QueryColumn.column(COLUMN_PLAYER_ID, characterPlayer.getPlayerId()), QueryColumn.column(COLUMN_FRIENDSHIP_PERCENTAGE, characterPlayer.getFriendshipPercentage())).execute();
    }
}

