/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.character;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.character.CharacterProfile;
import com.equestricraft.core.character.CharacterProfileRepository;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.character.CharacterPlayer;
import com.equestricraft.core.player.character.CharacterPlayerRepository;
import com.equestricraft.core.player.character.CharacterPlayerSession;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public class CharacterPlayerSessionImpl
implements CharacterPlayerSession {
    @Service
    private CharacterPlayerRepository characterPlayerRepository;
    @Service
    private CharacterProfileRepository characterProfileRepository;

    @Override
    public boolean hasPlayerMetCharacter(ECPlayer player, int characterId) {
        Optional<CharacterPlayer> characterPlayer = this.characterPlayerRepository.findByCharacterAndPlayer(characterId, player.getId());
        return characterPlayer.isPresent();
    }

    @Override
    public List<CharacterProfile> getCharactersPlayerHasMet(ECPlayer player) {
        List<CharacterPlayer> characterPlayers = this.characterPlayerRepository.findByPlayer(player.getId());
        List<Integer> characterIds = characterPlayers.stream().map(CharacterPlayer::getCharacterId).toList();
        return this.characterProfileRepository.findByKeys(characterIds);
    }

    @Override
    public Optional<Duration> getDurationSincePlayerFirstMetCharacter(ECPlayer player, CharacterProfile characterProfile) {
        Optional<CharacterPlayer> characterPlayer = this.characterPlayerRepository.findByCharacterAndPlayer(characterProfile.getId(), player.getId());
        if (characterPlayer.isPresent()) {
            Duration durationSinceFirstMet = DateUtils.durationSince(characterPlayer.get().getFirstMet());
            return Optional.ofNullable(durationSinceFirstMet);
        }
        return Optional.empty();
    }

    @Override
    public Optional<Duration> getDurationSincePlayerLastSawCharacter(ECPlayer player, int characterId) {
        Optional<CharacterPlayer> characterPlayer = this.characterPlayerRepository.findByCharacterAndPlayer(characterId, player.getId());
        if (characterPlayer.isPresent()) {
            Duration durationSinceLastSeen = DateUtils.durationSince(characterPlayer.get().getLastSeen());
            return Optional.ofNullable(durationSinceLastSeen);
        }
        return Optional.empty();
    }

    @Override
    public void processPlayerInteractionWithCharacter(ECPlayer player, int characterId) {
        long time = System.currentTimeMillis();
        Optional<CharacterPlayer> characterPlayer = this.characterPlayerRepository.findByCharacterAndPlayer(characterId, player.getId());
        if (characterPlayer.isPresent()) {
            characterPlayer.get().setLastSeen(time);
            characterPlayer.get().save();
        } else {
            CharacterProfile character = (CharacterProfile)this.characterProfileRepository.findByKey(characterId);
            CharacterPlayer newCharacterPlayer = new CharacterPlayer(characterId, player.getId(), time, time, character.getInitialFriendshipPercentage());
            this.characterPlayerRepository.add(newCharacterPlayer);
            player.sendToast(I18n.getLabel("compendium.updated"));
        }
    }

    @Override
    public Optional<Double> getPlayersFriendshipPercentageWithCharacter(ECPlayer player, int characterId) {
        Optional<CharacterPlayer> characterPlayer = this.characterPlayerRepository.findByCharacterAndPlayer(characterId, player.getId());
        return characterPlayer.map(CharacterPlayer::getFriendshipPercentage);
    }

    @Override
    public void incrementPlayersFriendshipPercentageWithCharacter(ECPlayer player, int characterId, double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("Must be zero or greater");
        }
        if (amount == 0.0) {
            return;
        }
        this.offsetFriendshipPercentage(player, characterId, amount);
    }

    @Override
    public void decrementPlayersFriendshipPercentageWithCharacter(ECPlayer player, int characterId, double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("Must be zero or greater");
        }
        if (amount == 0.0) {
            return;
        }
        this.offsetFriendshipPercentage(player, characterId, -amount);
    }

    private void offsetFriendshipPercentage(ECPlayer player, int characterId, double amount) {
        CharacterPlayer characterPlayer = this.characterPlayerRepository.findByCharacterAndPlayer(characterId, player.getId()).orElseThrow();
        double current = characterPlayer.getFriendshipPercentage();
        characterPlayer.setFriendshipPercentage(current += amount);
        characterPlayer.save();
    }

    @Override
    public void setPlayersFriendshipPercentageWithCharacter(ECPlayer player, int characterId, double value) {
        CharacterPlayer characterPlayer = this.characterPlayerRepository.findByCharacterAndPlayer(characterId, player.getId()).orElseThrow();
        characterPlayer.setFriendshipPercentage(value);
        characterPlayer.save();
    }
}

