/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.character;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.character.CharacterProfile;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.character.CharacterPlayerSession;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public class PlayerCharacterAccessor
extends AbstractPlayerAccessor {
    @Service
    private static CharacterPlayerSession characterPlayerSession;

    public PlayerCharacterAccessor(CorePlayer player) {
        super(player);
    }

    public boolean hasPlayerMetCharacter(int characterId) {
        return characterPlayerSession.hasPlayerMetCharacter(this.player, characterId);
    }

    public List<CharacterProfile> getMetCharacters() {
        return characterPlayerSession.getCharactersPlayerHasMet(this.player);
    }

    public Optional<Duration> getDurationSinceFirstMet(CharacterProfile characterProfile) {
        return characterPlayerSession.getDurationSincePlayerFirstMetCharacter(this.player, characterProfile);
    }

    public Optional<Duration> getDurationSinceLastSeen(int characterId) {
        return characterPlayerSession.getDurationSincePlayerLastSawCharacter(this.player, characterId);
    }

    public Optional<Double> getFriendshipPercentage(int characterId) {
        return characterPlayerSession.getPlayersFriendshipPercentageWithCharacter(this.player, characterId);
    }

    public void incrementFriendshipPercentage(int characterId, double amount) {
        characterPlayerSession.incrementPlayersFriendshipPercentageWithCharacter(this.player, characterId, amount);
    }

    public void decrementFriendshipPercentage(int characterId, double amount) {
        characterPlayerSession.decrementPlayersFriendshipPercentageWithCharacter(this.player, characterId, amount);
    }

    public void setFriendshipPercentage(int characterId, double value) {
        characterPlayerSession.setPlayersFriendshipPercentageWithCharacter(this.player, characterId, value);
    }

    public void processInteraction(int characterId) {
        characterPlayerSession.processPlayerInteractionWithCharacter(this.player, characterId);
    }
}

