/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.chattag;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.core.chattag.ChatTag;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.chattag.PlayerChatTagSession;
import com.equestricraft.dataload.DataLoadModule;
import com.equestricraft.dataload.DataLoadSubscriber;
import java.util.Optional;

public class PlayerChatTagAccessor
extends AbstractPlayerAccessor {
    @Service
    private static PlayerChatTagSession playerChatTagSession;
    private static final DataLoadSubscriber chatTagUpdateSubscriber;
    private final CachedValue<ChatTag> chatTag = new CachedValue<ChatTag>(this::getUpdatedChatTag);

    public PlayerChatTagAccessor(CorePlayer player) {
        super(player);
        chatTagUpdateSubscriber.subscribe(this.chatTag::expire);
    }

    public void setCurrent(ChatTag chatTag) {
        playerChatTagSession.setPlayersActiveChatTag(this.player, chatTag);
        this.chatTag.set(chatTag);
    }

    public void clearCurrent() {
        playerChatTagSession.clearPlayersActiveChatTag(this.player);
        this.chatTag.expire();
    }

    public Optional<ChatTag> getCurrent() {
        return Optional.ofNullable(this.chatTag.get());
    }

    private ChatTag getUpdatedChatTag() {
        return playerChatTagSession.getPlayersCurrentTag(this.player).orElse(null);
    }

    static {
        chatTagUpdateSubscriber = new DataLoadSubscriber(DataLoadModule.CHAT_TAGS);
    }
}

