/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.chattag;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.chattag.ChatTag;
import com.equestricraft.core.chattag.ChatTagRepository;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.chattag.PlayerChatTagSession;
import com.equestricraft.core.player.chattag.access.ChatTagPlayerAccessSession;
import com.equestricraft.logging.Log;
import java.util.Optional;

public class PlayerChatTagSessionImpl
implements PlayerChatTagSession {
    @Service
    private ChatTagRepository chatTagRepository;
    @Service
    private ChatTagPlayerAccessSession chatTagPlayerAccessSession;
    private static final Log log = Log.getLogger(PlayerChatTagSessionImpl.class.getName());

    @Override
    public void setPlayersActiveChatTag(ECPlayer player, ChatTag chatTag) {
        if (this.chatTagPlayerAccessSession.canPlayerAccessTag(player, chatTag.getId())) {
            player.getCorePlayer().setActiveTagId(chatTag.getId());
            player.getCorePlayer().save();
        } else {
            log.warn("{} tried to set chat tag {} but they do not have access to it", (Object)player.getIgn(), (Object)chatTag.getName());
        }
    }

    @Override
    public void clearPlayersActiveChatTag(ECPlayer player) {
        player.getCorePlayer().setActiveTagId(null);
        player.getCorePlayer().save();
    }

    @Override
    public Optional<ChatTag> getPlayersCurrentTag(ECPlayer player) {
        Integer activeTagId = player.getCorePlayer().getActiveTagId();
        if (activeTagId == null) {
            return Optional.empty();
        }
        ChatTag chatTat = (ChatTag)this.chatTagRepository.findByKey(activeTagId);
        return Optional.of(chatTat);
    }
}

