/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.chattag.access;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.chattag.access.ChatTagPlayer;
import com.equestricraft.core.player.chattag.access.ChatTagPlayerAccessSession;
import com.equestricraft.core.player.chattag.access.ChatTagPlayerRepository;
import java.util.Optional;

public class ChatTagPlayerAccessSessionImpl
implements ChatTagPlayerAccessSession {
    @Service
    private ChatTagPlayerRepository chatTagPlayerRepository;

    @Override
    public void grantPlayerAccessToTag(ECPlayer player, int tagId) {
        ChatTagPlayer chatTagPlayer = new ChatTagPlayer(tagId, player.getId());
        this.chatTagPlayerRepository.add(chatTagPlayer);
    }

    @Override
    public void revokePlayerAccessFromTag(ECPlayer player, int tagId) {
        Optional<ChatTagPlayer> existing = this.chatTagPlayerRepository.findByTagAndPlayer(tagId, player.getId());
        existing.ifPresent(chatTagPlayer -> this.chatTagPlayerRepository.remove(chatTagPlayer));
    }

    @Override
    public boolean canPlayerAccessTag(ECPlayer player, int tagId) {
        if (player.getPermission().hasPermission("equestricraft.chat-tag.admin")) {
            return true;
        }
        return this.chatTagPlayerRepository.findByTagAndPlayer(tagId, player.getId()).isPresent();
    }
}

