/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.chattag.access;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.chattag.access.ChatTagPlayer;
import com.equestricraft.core.player.chattag.access.ChatTagPlayerKey;
import java.util.List;

public class ChatTagPlayerDatabase
implements RepositoryDatasource<ChatTagPlayer, ChatTagPlayerKey> {
    private static final String COLUMN_CHAT_TAG_ID = "CHAT_TAG_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";

    @Override
    public void create(ChatTagPlayer chatTagPlayer) {
        Query.insertInto("CHAT_TAG_PLAYER").columns(QueryColumn.column(COLUMN_CHAT_TAG_ID, chatTagPlayer.getChatTagId()), QueryColumn.column(COLUMN_PLAYER_ID, chatTagPlayer.getPlayerId())).execute();
    }

    @Override
    public List<ChatTagPlayer> retrieveAll() {
        return Query.selectAllFrom("CHAT_TAG_PLAYER").getList(this::getFromResultRow);
    }

    @Override
    public void deleteByKey(ChatTagPlayerKey chatTagPlayerKey) {
        Query.deleteFrom("CHAT_TAG_PLAYER").where(QueryColumn.column(COLUMN_CHAT_TAG_ID, chatTagPlayerKey.chatTagId()), QueryColumn.column(COLUMN_PLAYER_ID, chatTagPlayerKey.playerId())).execute();
    }

    private ChatTagPlayer getFromResultRow(ResultRow row) {
        int chatTagId = row.getInt(COLUMN_CHAT_TAG_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        return new ChatTagPlayer(chatTagId, playerId);
    }
}

